/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.rest;

import jakarta.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.ProvidersRegistry;
import org.exoplatform.services.rest.impl.RequestDispatcher;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.tools.ResourceLauncher;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPeriodWithFullDate;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.reward.rest.RewardSettingsREST;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestRewardSettingsREST {
    @Mock
    private RewardSettingsService rewardSettingsService;
    @Mock
    private ExoContainerContext containerContext;
    @Mock
    private ExoContainer container;
    private ResourceLauncher launcher;
    private RewardSettingsREST rewardSettingsREST;

    @Before
    public void setUp() {
        if (this.rewardSettingsREST == null) {
            this.rewardSettingsREST = new RewardSettingsREST(this.rewardSettingsService);
        }
        Mockito.when((Object)this.containerContext.getName()).thenReturn((Object)"portal");
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
    }

    @Test
    public void testGetNegativeTimeZone() throws Exception {
        String restPath = "/wallet/api/reward/settings/getDates?date=2022-09-20";
        String timeZone = "America/Rio_Branco";
        RewardSettings settings = new RewardSettings();
        settings.setTimeZone(timeZone);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)settings);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse response = this.getLauncher().service("GET", restPath, "", null, null, envctx);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        RewardPeriodWithFullDate periodWithFullDate = (RewardPeriodWithFullDate)response.getEntity();
        Assert.assertNotNull((Object)periodWithFullDate);
        Assert.assertEquals((Object)"2022-09-01T00:00:00.000-05:00", (Object)periodWithFullDate.getStartDate());
        Assert.assertEquals((long)1662008400L, (long)periodWithFullDate.getStartDateInSeconds());
        Assert.assertEquals((Object)"2022-09-30T23:59:59.000-05:00", (Object)periodWithFullDate.getEndDate());
        Assert.assertEquals((long)1664600400L, (long)periodWithFullDate.getEndDateInSeconds());
        Assert.assertEquals((Object)RewardPeriodType.DEFAULT, (Object)periodWithFullDate.getRewardPeriodType());
        Assert.assertEquals((Object)timeZone, (Object)periodWithFullDate.getTimeZone());
    }

    @Test
    public void testGetPositiveTimeZone() throws Exception {
        String restPath = "/wallet/api/reward/settings/getDates?date=2022-09-20";
        String timeZone = "Asia/Tokyo";
        RewardSettings settings = new RewardSettings();
        settings.setTimeZone(timeZone);
        settings.setPeriodType(RewardPeriodType.WEEK);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)settings);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse response = this.getLauncher().service("GET", restPath, "", null, null, envctx);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        RewardPeriodWithFullDate periodWithFullDate = (RewardPeriodWithFullDate)response.getEntity();
        Assert.assertNotNull((Object)periodWithFullDate);
        Assert.assertEquals((Object)"2022-09-19T00:00:00.000+09:00", (Object)periodWithFullDate.getStartDate());
        Assert.assertEquals((long)1663513200L, (long)periodWithFullDate.getStartDateInSeconds());
        Assert.assertEquals((Object)"2022-09-25T23:59:59.000+09:00", (Object)periodWithFullDate.getEndDate());
        Assert.assertEquals((long)1664118000L, (long)periodWithFullDate.getEndDateInSeconds());
        Assert.assertEquals((Object)RewardPeriodType.WEEK, (Object)periodWithFullDate.getRewardPeriodType());
        Assert.assertEquals((Object)timeZone, (Object)periodWithFullDate.getTimeZone());
    }

    @Test
    public void testGetDSTTimeZone() throws Exception {
        String restPath = "/wallet/api/reward/settings/getDates?date=2022-10-25";
        String timeZone = "Europe/Paris";
        RewardSettings settings = new RewardSettings();
        settings.setTimeZone(timeZone);
        settings.setPeriodType(RewardPeriodType.WEEK);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)settings);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse response = this.getLauncher().service("GET", restPath, "", null, null, envctx);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        RewardPeriodWithFullDate periodWithFullDate = (RewardPeriodWithFullDate)response.getEntity();
        Assert.assertNotNull((Object)periodWithFullDate);
        Assert.assertEquals((Object)"2022-10-24T00:00:00.000+02:00", (Object)periodWithFullDate.getStartDate());
        Assert.assertEquals((long)1666562400L, (long)periodWithFullDate.getStartDateInSeconds());
        Assert.assertEquals((Object)"2022-10-30T23:59:59.000+01:00", (Object)periodWithFullDate.getEndDate());
        Assert.assertEquals((long)1667170800L, (long)periodWithFullDate.getEndDateInSeconds());
        Assert.assertEquals((Object)RewardPeriodType.WEEK, (Object)periodWithFullDate.getRewardPeriodType());
        Assert.assertEquals((Object)timeZone, (Object)periodWithFullDate.getTimeZone());
    }

    private ResourceLauncher getLauncher() throws Exception {
        if (this.launcher == null) {
            ResourceBinder resourceBinder = new ResourceBinder(this.containerContext);
            resourceBinder.addResource((Object)this.rewardSettingsREST, null);
            ProvidersRegistry providers = new ProvidersRegistry();
            RequestDispatcher requestDispatcher = new RequestDispatcher(resourceBinder, providers);
            RequestHandlerImpl requestHandler = new RequestHandlerImpl(requestDispatcher, null);
            this.launcher = new ResourceLauncher((RequestHandler)requestHandler);
        }
        return this.launcher;
    }
}

