/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.reward.service.RewardTeamService;
import org.exoplatform.wallet.utils.RewardUtils;

@Path(value="/wallet/api/reward/team")
@RolesAllowed(value={"rewarding"})
@Tag(name="/wallet/api/reward/team", description="Manage reward teams (pools)")
public class RewardTeamREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardTeamREST.class);
    private RewardTeamService rewardTeamService;

    public RewardTeamREST(RewardTeamService rewardTeamService) {
        this.rewardTeamService = rewardTeamService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Get reward teams with their members", method="GET", description="returns the list of reward team objects")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response listTeams() {
        try {
            return Response.ok(this.rewardTeamService.getTeams()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="remove")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Remove a reward team", method="GET", description="Remove a reward team and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response removeTeam(@Parameter(description="Reward team technical id", required=true) @QueryParam(value="id") Long id) {
        if (id == null || id == 0L) {
            return Response.status((int)400).build();
        }
        try {
            RewardTeam team = this.rewardTeamService.removeTeam(id);
            LOG.info("{} removed reward pool {}", new Object[]{RewardUtils.getCurrentUserId(), team.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error removing reward pool with id: " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Save a reward team", method="POST", description="Save a reward team and returns the saved reward team object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveTeam(@Parameter(description="Reward team object", required=true) RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            LOG.warn((Object)"Bad request sent to server with empty team");
            return Response.status((int)400).build();
        }
        try {
            rewardTeam = this.rewardTeamService.saveTeam(rewardTeam);
            LOG.info("{} saved reward pool {}", new Object[]{RewardUtils.getCurrentUserId(), rewardTeam.getName()});
            return Response.ok((Object)rewardTeam).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving reward pool", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

