/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.model.transaction.TransactionStatistics;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.WalletUtils;

@Path(value="/wallet/api/transaction")
@RolesAllowed(value={"users"})
@Tag(name="/wallet/api/transaction", description="Manages internally stored transactions")
public class WalletTransactionREST
implements ResourceContainer {
    private static final String EMPTY_ADDRESS_ERROR = "Bad request sent to server with empty address {}";
    private static final Log LOG = ExoLogger.getLogger(WalletTransactionREST.class);
    private BlockchainTransactionService blockchainTransactionService;
    private WalletTransactionService transactionService;
    private WalletTokenAdminService walletTokenAdminService;
    private WalletService walletService;

    public WalletTransactionREST(WalletTransactionService transactionService, WalletService walletService) {
        this.transactionService = transactionService;
        this.walletService = walletService;
    }

    @POST
    @Path(value="saveTransactionDetails")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Save transaction details in internal datasource", method="POST", description="Save transaction details in internal datasource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveTransactionDetails(@RequestBody(description="transaction detail object", required=true) TransactionDetail transactionDetail) {
        if (transactionDetail == null || StringUtils.isBlank((CharSequence)transactionDetail.getFrom())) {
            LOG.warn("Bad request sent to server with empty transaction details: {}", new Object[]{transactionDetail == null ? "" : transactionDetail.toString()});
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getRawTransaction())) {
            String transactionHash = this.getWalletTokenAdminService().generateHash(transactionDetail.getRawTransaction());
            transactionDetail.setHash(transactionHash);
        } else if (StringUtils.isBlank((CharSequence)transactionDetail.getHash())) {
            LOG.warn((Object)"Bad request sent to server with empty transaction hash");
            return Response.status((int)400).build();
        }
        try {
            this.transactionService.saveTransactionDetail(transactionDetail, currentUserId);
            return Response.ok((Object)transactionDetail).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} is attempting to save transaction {}", new Object[]{currentUserId, transactionDetail, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Error saving transaction message {}", new Object[]{transactionDetail, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getSavedTransactionByHash")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get saved transaction in internal database by hash", method="GET", description="Get saved transaction in internal database by hash and returns transaction detail")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSavedTransactionByHash(@Parameter(description="transaction hash", required=true) @QueryParam(value="hash") String hash) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            LOG.warn("Empty transaction hash", new Object[]{hash});
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = this.transactionService.getTransactionByHash(hash, WalletUtils.getCurrentUserId());
            return Response.ok((Object)transactionDetail).build();
        }
        catch (Exception e) {
            LOG.error("Error getting transaction with hash {}", new Object[]{hash, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="getNonce")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get nonce to include in next transaction to send for a wallet", method="GET", description="Get nonce to include in next transaction to send for a wallet")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getNonce(@Parameter(description="Transaction sender address", required=true) @QueryParam(value="from") String fromAddress) {
        if (StringUtils.isBlank((CharSequence)fromAddress)) {
            LOG.warn("Empty transaction sender", new Object[]{fromAddress});
            return Response.status((int)400).build();
        }
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            long nonce = this.transactionService.getNonce(fromAddress, currentUser);
            return Response.ok((Object)String.valueOf(nonce)).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display last nonce of address {}", new Object[]{currentUser, fromAddress, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Error getting nonce for address {}", new Object[]{fromAddress, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="getGasPrice")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get current gas price from blockchain", method="GET", description="Get current gas price from blockchain to be used to send a transaction")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getGasPrice() {
        double gasPrice = this.walletService.getGasPrice();
        return Response.ok((Object)BigDecimal.valueOf(gasPrice).toBigInteger().toString()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactionsAmounts")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get token amounts sent per each period of time by a wallet identified by its address", method="GET", description="returns transaction statistics object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getTransactionsAmounts(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address, @Parameter(description="periodicity : month or year", required=true) @QueryParam(value="periodicity") String periodicity, @Parameter(description="Selected date") @QueryParam(value="date") String selectedDate, @Parameter(description="user locale language") @QueryParam(value="lang") String lang) {
        if (StringUtils.isBlank((CharSequence)periodicity)) {
            LOG.warn((Object)"Bad request sent to server with empty periodicity parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        try {
            TransactionStatistics transactionStatistics = this.transactionService.getTransactionStatistics(address, periodicity, selectedDate, new Locale(lang));
            return Response.ok((Object)transactionStatistics).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting transactions statistics of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactions")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get list of transactions of an address", method="GET", description="returns list of transaction detail object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getTransactions(@Parameter(description="wallet address", required=true) @QueryParam(value="address") String address, @Parameter(description="token contract address to filter with") @QueryParam(value="contractAddress") String contractAddress, @Parameter(description="token contract method to filter with") @QueryParam(value="contractMethodName") String contractMethodName, @Parameter(description="transaction hash to include in response") @QueryParam(value="hash") String hash, @Parameter(description="limit transactions to retrieve") @QueryParam(value="limit") int limit, @Parameter(description="whether to include only pending or not") @QueryParam(value="pending") boolean onlyPending, @Parameter(description="whether to include administration transactions or not") @QueryParam(value="administration") boolean administration) {
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isBlank((CharSequence)address)) {
            LOG.warn((Object)"Bad request sent to server with empty wallet address");
            return Response.status((int)400).build();
        }
        try {
            List<TransactionDetail> transactionDetails = this.transactionService.getTransactions(address, contractAddress, contractMethodName, hash, limit, onlyPending, administration, currentUserId);
            return Response.ok(transactionDetails).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display transactions of address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting transactions of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="refreshTransactionFromBlockchain")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="refresh transaction detail from blockchain", method="GET", description="return transaction detail refreshed from blockchain")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="200", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response refreshTransactionFromBlockchain(@Parameter(description="transaction hash", required=true) @QueryParam(value="hash") String hash) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            LOG.warn((Object)"Bad request sent to server with empty transaction hash");
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = this.getBlockchainTransactionService().refreshTransactionFromBlockchain(hash);
            return Response.ok((Object)transactionDetail).build();
        }
        catch (Exception e) {
            LOG.error("Error refreshing transaction with hash {} from blockchain", new Object[]{hash, e});
            return Response.serverError().build();
        }
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }

    public BlockchainTransactionService getBlockchainTransactionService() {
        if (this.blockchainTransactionService == null) {
            this.blockchainTransactionService = (BlockchainTransactionService)CommonsUtils.getService(BlockchainTransactionService.class);
        }
        return this.blockchainTransactionService;
    }
}

