/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.dao;

import jakarta.persistence.TypedQuery;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.reward.entity.WalletRewardPluginEntity;

public class RewardPluginDAO
extends GenericDAOJPAImpl<WalletRewardPluginEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(RewardPluginDAO.class);

    public List<WalletRewardPluginEntity> getRewardPluginsByRewardId(long rewardId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPlugin.getRewardPluginsByRewardId", WalletRewardPluginEntity.class);
        query.setParameter("rewardId", (Object)rewardId);
        return query.getResultList();
    }

    public WalletRewardPluginEntity getRewardPluginsByRewardIdAndPluginId(long rewardId, String pluginId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPlugin.getRewardPluginsByRewardIdAndPluginId", WalletRewardPluginEntity.class);
        query.setParameter("rewardId", (Object)rewardId);
        query.setParameter("pluginId", (Object)pluginId);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one reward plugin was found for rewardId {} and pluginId {}", new Object[]{rewardId, pluginId});
        }
        return (WalletRewardPluginEntity)result.get(0);
    }
}

