/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.utils.WalletUtils;

public class RewardTransaction
implements Serializable {
    private static final long serialVersionUID = 658273092293607458L;
    private String hash;
    private String periodType;
    private long startDateInSeconds;
    private String receiverType;
    private String receiverId;
    private long receiverIdentityId;
    private double tokensSent;
    private String status;

    public static RewardTransaction fromStoredValue(String storedTransactionDetails) {
        RewardTransaction transaction = new RewardTransaction();
        if (StringUtils.isNotBlank((CharSequence)storedTransactionDetails)) {
            String[] transactionDetailsArray = storedTransactionDetails.split(";");
            transaction.setHash(transactionDetailsArray[0]);
            transaction.setReceiverType(transactionDetailsArray.length > 1 ? WalletUtils.decodeString(transactionDetailsArray[1]) : null);
            transaction.setReceiverId(transactionDetailsArray.length > 2 ? WalletUtils.decodeString(transactionDetailsArray[2]) : null);
            String tokensSentString = transactionDetailsArray.length > 3 ? transactionDetailsArray[3] : null;
            transaction.setTokensSent(StringUtils.isBlank((CharSequence)tokensSentString) ? 0.0 : Double.parseDouble(tokensSentString));
            String receiverIdentityId = transactionDetailsArray.length > 4 ? transactionDetailsArray[4] : null;
            transaction.setReceiverIdentityId(StringUtils.isBlank((CharSequence)receiverIdentityId) || StringUtils.equals((CharSequence)"null", (CharSequence)receiverIdentityId) ? 0L : Long.parseLong(receiverIdentityId));
        }
        return transaction;
    }

    public String getToStoreValue() {
        Identity receiverIdentity = null;
        if (this.receiverIdentityId > 0L) {
            receiverIdentity = WalletUtils.getIdentityById(this.receiverIdentityId);
        } else {
            if (StringUtils.isBlank((CharSequence)this.receiverType)) {
                throw new IllegalStateException("receiverType is mandatory");
            }
            if (StringUtils.isBlank((CharSequence)this.receiverId)) {
                throw new IllegalStateException("receiverId is mandatory");
            }
            receiverIdentity = WalletUtils.getIdentityByTypeAndId(WalletType.getType(this.receiverType), this.receiverId);
        }
        return this.hash + ";;;" + this.tokensSent + ";" + receiverIdentity.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RewardTransaction)) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)this.hash, (CharSequence)((RewardTransaction)obj).getHash());
    }

    public int hashCode() {
        return this.hash == null ? 0 : this.hash.hashCode();
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getPeriodType() {
        return this.periodType;
    }

    @Generated
    public long getStartDateInSeconds() {
        return this.startDateInSeconds;
    }

    @Generated
    public String getReceiverType() {
        return this.receiverType;
    }

    @Generated
    public String getReceiverId() {
        return this.receiverId;
    }

    @Generated
    public long getReceiverIdentityId() {
        return this.receiverIdentityId;
    }

    @Generated
    public double getTokensSent() {
        return this.tokensSent;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    @Generated
    public void setStartDateInSeconds(long startDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
    }

    @Generated
    public void setReceiverType(String receiverType) {
        this.receiverType = receiverType;
    }

    @Generated
    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    @Generated
    public void setReceiverIdentityId(long receiverIdentityId) {
        this.receiverIdentityId = receiverIdentityId;
    }

    @Generated
    public void setTokensSent(double tokensSent) {
        this.tokensSent = tokensSent;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public String toString() {
        return "RewardTransaction(hash=" + this.getHash() + ", periodType=" + this.getPeriodType() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", receiverType=" + this.getReceiverType() + ", receiverId=" + this.getReceiverId() + ", receiverIdentityId=" + this.getReceiverIdentityId() + ", tokensSent=" + this.getTokensSent() + ", status=" + this.getStatus() + ")";
    }
}

