/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.notification;

import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.reward.BaseWalletRewardTest;
import org.exoplatform.wallet.reward.notification.RewardSuccessNotificationPlugin;
import org.exoplatform.wallet.reward.notification.RewardSuccessTemplateProvider;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.exoplatform.wallet.reward.service.WalletRewardSettingsService;
import org.exoplatform.wallet.utils.RewardUtils;
import org.junit.Test;

public class RewardSuccessTemplateBuilderTest
extends BaseWalletRewardTest {
    @Test
    public void testBuildMessage() {
        InitParams params = this.getParams();
        RewardSuccessNotificationPlugin plugin = new RewardSuccessNotificationPlugin(params);
        RewardSuccessTemplateProvider templateProvider = new RewardSuccessTemplateProvider(this.container, (RewardSettingsService)this.getService(WalletRewardSettingsService.class), params);
        templateProvider.setMailTemplatePath("jar:/template/RewardSuccessReward.gtmpl");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        RewardReport rewardReport = new RewardReport();
        RewardPeriod rewardPeriod = RewardPeriod.getCurrentPeriod((RewardSettings)RewardUtils.getRewardSettings());
        rewardReport.setPeriod(rewardPeriod);
        HashSet<WalletReward> rewards = new HashSet<WalletReward>();
        for (int i = 0; i < 30; ++i) {
            TransactionDetail transaction = new TransactionDetail();
            transaction.setHash("hash");
            transaction.setContractAmount(2.0);
            transaction.setPending(true);
            rewards.add(new WalletReward(null, null, transaction, null, null));
        }
        rewardReport.setRewards(rewards);
        ctx.append(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM, (Object)rewardReport);
        NotificationInfo notification = plugin.buildNotification(ctx);
        ctx.setNotificationInfo(notification);
        notification.to((String)notification.getSendToUserIds().get(0));
        ((PluginSettingService)CommonsUtils.getService(PluginSettingService.class)).registerPluginConfig(this.getPluginConfig());
        ((PluginContainer)CommonsUtils.getService(PluginContainer.class)).addPlugin((BaseNotificationPlugin)plugin);
        ((ChannelManager)CommonsUtils.getService(ChannelManager.class)).registerOverrideTemplateProvider((TemplateProvider)templateProvider);
        MessageInfo message = templateProvider.getBuilder().buildMessage(ctx);
        RewardSuccessTemplateBuilderTest.assertNotNull((Object)message);
        RewardSuccessTemplateBuilderTest.assertNotNull((Object)message.getPluginId());
        RewardSuccessTemplateBuilderTest.assertEquals((String)"Reward success!", (String)message.getBody().replaceAll("(?s)<!--.*?-->", "").trim());
    }

    private InitParams getParams() {
        InitParams initParams = new InitParams();
        ObjectParameter objectParam = new ObjectParameter();
        objectParam.setName("plugin-config");
        PluginConfig pluginConfig = this.getPluginConfig();
        objectParam.setObject((Object)pluginConfig);
        initParams.addParam((Object)objectParam);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("channel-id");
        valueParam.setValue("MAIL_CHANNEL");
        initParams.addParam((Object)valueParam);
        return initParams;
    }

    private PluginConfig getPluginConfig() {
        PluginConfig pluginConfig = new PluginConfig();
        pluginConfig.setPluginId("RewardSuccessNotificationPlugin");
        pluginConfig.setResourceBundleKey("UINotification.label.RewardSuccessNotificationPlugin");
        pluginConfig.setOrder("1");
        pluginConfig.setGroupId("wallet");
        pluginConfig.setBundlePath("locale.notification.WalletNotification");
        return pluginConfig;
    }
}

