/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.scheduling;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.reward.scheduling.task.RewardStatusVerifierTask;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.service.WalletAccountService;
import java.time.LocalDate;
import java.util.List;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={RewardStatusVerifierTask.class})
class RewardStatusVerifierTaskTest {
    @MockBean
    private RewardReportService rewardReportService;
    @MockBean
    private WalletAccountService walletAccountService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private RewardStatusVerifierTask rewardStatusVerifierTask;

    RewardStatusVerifierTaskTest() {
    }

    @Test
    void testSendRewards_NoAdminWallet() {
        Mockito.when((Object)this.walletAccountService.getAdminWallet()).thenReturn(null);
        Mockito.when((Object)this.walletAccountService.isAdminAccountEnabled()).thenReturn((Object)true);
        this.rewardStatusVerifierTask.execute();
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.never())).getRewardPeriodsInProgress();
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast(Mockito.anyString(), Mockito.any(), Mockito.any());
    }

    @Test
    void testSendRewards_RewardPeriodsInProgress() {
        Wallet adminWallet = new Wallet();
        adminWallet.setEtherBalance(Double.valueOf(100.0));
        adminWallet.setTokenBalance(Double.valueOf(100.0));
        Mockito.when((Object)this.walletAccountService.getAdminWallet()).thenReturn((Object)adminWallet);
        Mockito.when((Object)this.walletAccountService.isAdminAccountEnabled()).thenReturn((Object)true);
        RewardPeriod rewardPeriod = new RewardPeriod();
        List<RewardPeriod> rewardPeriodsInProgress = List.of(rewardPeriod);
        Mockito.when((Object)this.rewardReportService.getRewardPeriodsInProgress()).thenReturn(rewardPeriodsInProgress);
        RewardReport rewardReport = (RewardReport)Mockito.mock(RewardReport.class);
        Mockito.when((Object)rewardReport.isCompletelyProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.rewardReportService.computeRewards((LocalDate)Mockito.any())).thenReturn((Object)rewardReport);
        this.rewardStatusVerifierTask.execute();
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).computeRewards((LocalDate)Mockito.any());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.reward.report.success", (Object)rewardReport, null);
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).saveRewardReport((RewardReport)Mockito.any(RewardReport.class));
    }
}

