/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.notification;

import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.reward.notification.RewardSuccessNotificationPlugin;
import io.meeds.wallet.utils.RewardUtils;
import io.meeds.wallet.utils.WalletUtils;
import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParam;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class RewardSuccessNotificationPluginTest {
    @Test
    public void testMakeMessage() {
        try (MockedStatic walletUtilsMockedStatic = Mockito.mockStatic(WalletUtils.class);){
            ContractDetail mockContractDetail = new ContractDetail();
            mockContractDetail.setDecimals(Integer.valueOf(12));
            walletUtilsMockedStatic.when(WalletUtils::getContractDetail).thenReturn((Object)mockContractDetail);
            HashSet<String> rewardAdministrators = new HashSet<String>();
            rewardAdministrators.add("admin");
            walletUtilsMockedStatic.when(WalletUtils::getRewardAdministrators).thenReturn(rewardAdministrators);
            RewardSuccessNotificationPlugin plugin = new RewardSuccessNotificationPlugin(this.getParams());
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            RewardReport rewardReport = new RewardReport();
            RewardPeriod rewardPeriod = RewardPeriod.getCurrentPeriod((RewardSettings)new RewardSettings());
            rewardReport.setPeriod(rewardPeriod);
            HashSet<WalletReward> rewards = new HashSet<WalletReward>();
            for (int i = 0; i < 30; ++i) {
                TransactionDetail transaction = new TransactionDetail();
                transaction.setHash("hash");
                transaction.setContractAmount(2.0);
                transaction.setPending(true);
                rewards.add(new WalletReward(1L, null, transaction, 0L, 0.0, 0.0, null, 1));
            }
            rewardReport.setRewards(rewards);
            ctx.append(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM, (Object)rewardReport);
            Assertions.assertTrue((boolean)plugin.isValid(ctx));
            NotificationInfo notification = plugin.buildNotification(ctx);
            Assertions.assertNotNull((Object)notification);
            Assertions.assertEquals((Object)String.valueOf(rewardReport.getFailedTransactionCount()), (Object)notification.getValueOwnerParameter("rewardFailCount"));
            Assertions.assertEquals((Object)String.valueOf(rewardReport.getSuccessTransactionCount()), (Object)notification.getValueOwnerParameter("rewardSuccessCount"));
            Assertions.assertEquals((Object)String.valueOf(rewardReport.getPendingTransactionCount()), (Object)notification.getValueOwnerParameter("rewardPendingCount"));
            Assertions.assertEquals((Object)String.valueOf(rewardReport.getTransactionsCount()), (Object)notification.getValueOwnerParameter("rewardTransactionCount"));
            Assertions.assertEquals((Object)String.valueOf(rewardReport.getValidRewardCount()), (Object)notification.getValueOwnerParameter("rewardValidMembersCount"));
            Assertions.assertEquals((Object)String.valueOf(rewardReport.getTokensSent()), (Object)notification.getValueOwnerParameter("amount"));
        }
    }

    private InitParams getParams() {
        InitParams initParams = new InitParams();
        ObjectParam objectParam = new ObjectParam();
        objectParam.setName("plugin-config");
        objectParam.setType(PluginConfig.class.getName());
        objectParam.addProperty("pluginId", "RewardSuccessNotificationPlugin");
        objectParam.addProperty("resourceBundleKey", "UINotification.label.RewardSuccessNotificationPlugin");
        objectParam.addProperty("order", "1");
        objectParam.addProperty("groupId", "wallet");
        objectParam.addProperty("bundlePath", "locale.notification.WalletNotification");
        initParams.addParam((Object)objectParam);
        return initParams;
    }
}

