/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.notification;

import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.reward.notification.RewardSuccessNotificationPlugin;
import io.meeds.wallet.reward.notification.RewardSuccessTemplateProvider;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.utils.RewardUtils;
import io.meeds.wallet.utils.WalletUtils;
import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/test-organization-configuration.xml")})
public class RewardSuccessTemplateBuilderTest
extends BaseExoTestCase {
    @Test
    public void testBuildMessage() {
        try (MockedStatic walletUtilsMockedStatic = Mockito.mockStatic(WalletUtils.class);){
            ContractDetail mockContractDetail = new ContractDetail();
            mockContractDetail.setDecimals(Integer.valueOf(12));
            walletUtilsMockedStatic.when(WalletUtils::getContractDetail).thenReturn((Object)mockContractDetail);
            HashSet<String> rewardAdministrators = new HashSet<String>();
            rewardAdministrators.add("root");
            walletUtilsMockedStatic.when(WalletUtils::getRewardAdministrators).thenReturn(rewardAdministrators);
            RewardSettingsService rewardSettingsService = (RewardSettingsService)Mockito.mock(RewardSettingsService.class);
            Mockito.when((Object)rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
            InitParams params = this.getParams();
            RewardSuccessNotificationPlugin plugin = new RewardSuccessNotificationPlugin(params);
            RewardSuccessTemplateProvider templateProvider = new RewardSuccessTemplateProvider(rewardSettingsService, params);
            templateProvider.setMailTemplatePath("jar:/template/RewardSuccessReward.gtmpl");
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            RewardReport rewardReport = new RewardReport();
            RewardPeriod rewardPeriod = RewardPeriod.getCurrentPeriod((RewardSettings)new RewardSettings());
            rewardReport.setPeriod(rewardPeriod);
            HashSet<WalletReward> rewards = new HashSet<WalletReward>();
            for (int i = 0; i < 30; ++i) {
                TransactionDetail transaction = new TransactionDetail();
                transaction.setHash("hash");
                transaction.setContractAmount(2.0);
                transaction.setPending(true);
                rewards.add(new WalletReward(1L, null, transaction, 0L, 0.0, 0.0, null, 1));
            }
            rewardReport.setRewards(rewards);
            ctx.append(RewardUtils.REWARD_REPORT_NOTIFICATION_PARAM, (Object)rewardReport);
            NotificationInfo notification = plugin.buildNotification(ctx);
            ctx.setNotificationInfo(notification);
            notification.to((String)notification.getSendToUserIds().getFirst());
            ((PluginSettingService)CommonsUtils.getService(PluginSettingService.class)).registerPluginConfig(this.getPluginConfig());
            ((PluginContainer)CommonsUtils.getService(PluginContainer.class)).addPlugin((BaseNotificationPlugin)plugin);
            ((ChannelManager)CommonsUtils.getService(ChannelManager.class)).registerOverrideTemplateProvider((TemplateProvider)templateProvider);
            MessageInfo message = templateProvider.getBuilder().buildMessage(ctx);
            RewardSuccessTemplateBuilderTest.assertNotNull((Object)message);
            RewardSuccessTemplateBuilderTest.assertNotNull((Object)message.getPluginId());
            RewardSuccessTemplateBuilderTest.assertEquals((String)"Reward success!", (String)message.getBody().replaceAll("(?s)<!--.*?-->", "").trim());
        }
    }

    private InitParams getParams() {
        InitParams initParams = new InitParams();
        ObjectParameter objectParam = new ObjectParameter();
        objectParam.setName("plugin-config");
        PluginConfig pluginConfig = this.getPluginConfig();
        objectParam.setObject((Object)pluginConfig);
        initParams.addParam((Object)objectParam);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("channel-id");
        valueParam.setValue("MAIL_CHANNEL");
        initParams.addParam((Object)valueParam);
        return initParams;
    }

    private PluginConfig getPluginConfig() {
        PluginConfig pluginConfig = new PluginConfig();
        pluginConfig.setPluginId("RewardSuccessNotificationPlugin");
        pluginConfig.setResourceBundleKey("UINotification.label.RewardSuccessNotificationPlugin");
        pluginConfig.setOrder("1");
        pluginConfig.setGroupId("wallet");
        pluginConfig.setBundlePath("locale.notification.WalletNotification");
        return pluginConfig;
    }
}

