/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.model.WalletRewardStatus;
import io.meeds.wallet.reward.rest.RewardReportREST;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.utils.WalletUtils;
import jakarta.servlet.Filter;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={RewardReportREST.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class TestRewardReportREST {
    private static final String REST_PATH = "/reward";
    private static final String SIMPLE_USER = "simple";
    private static final String ADMIN_USER = "admin";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @MockBean
    private RewardReportService rewardReportService;
    @MockBean
    private RewardSettingsService rewardSettingsService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    TestRewardReportREST() {
    }

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void computeRewardsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"12"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeRewardsSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"12"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeRewardsAdmin() throws Exception {
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        RewardPeriod rewardPeriod = new RewardPeriod();
        RewardReport rewardReport = new RewardReport();
        rewardReport.setPeriod(rewardPeriod);
        Mockito.when((Object)this.rewardReportService.computeRewards((LocalDate)Mockito.any(LocalDate.class))).thenReturn((Object)rewardReport);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"12"}).with(this.testAdminUser()));
        ((RewardSettingsService)Mockito.verify((Object)this.rewardSettingsService, (VerificationMode)Mockito.times((int)1))).getSettings();
        response.andExpect(MockMvcResultMatchers.status().isOk());
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(RewardPeriodType.MONTH);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"12"}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(RewardPeriodType.QUARTER);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"12"}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getWalletRewardsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/rewards", (Object[])new Object[0]).param("periodId", new String[]{"1"}).param("status", new String[]{"VALID"}).param("sortField", new String[]{"tokensSent"}).param("sortDir", new String[]{"desc"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWalletRewardsSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/rewards", (Object[])new Object[0]).param("periodId", new String[]{"1"}).param("status", new String[]{"VALID"}).param("sortField", new String[]{"tokensSent"}).param("sortDir", new String[]{"desc"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWalletRewardsAdmin() throws Exception {
        Mockito.when((Object)this.rewardReportService.findWalletRewardsByPeriodIdAndStatus(Mockito.anyLong(), Mockito.anyList(), (WalletRewardStatus)Mockito.any(WalletRewardStatus.class), (ZoneId)Mockito.any(ZoneId.class), (Pageable)Mockito.any(Pageable.class))).thenReturn((Object)new PageImpl(List.of(this.walletReward())));
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/rewards", (Object[])new Object[0]).param("periodId", new String[]{"1"}).param("status", new String[]{"VALID"}).param("sortField", new String[]{"tokensSent"}).param("sortDir", new String[]{"desc"}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void exportXlsxAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/export", (Object[])new Object[0]).param("periodId", new String[]{"1"}).param("status", new String[]{"VALID"}).param("fileName", new String[]{"fileName"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void exportXlsxSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/export", (Object[])new Object[0]).param("periodId", new String[]{"1"}).param("status", new String[]{"VALID"}).param("fileName", new String[]{"fileName"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void exportXlsxAdmin() throws Exception {
        RewardSettings rewardSettings = new RewardSettings();
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.rewardReportService.exportXlsx(1L, WalletRewardStatus.ALL, rewardSettings.zoneId(), "fileName", Locale.ENGLISH)).thenReturn((Object)inputStream);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/export", (Object[])new Object[0]).param("periodId", new String[]{"1"}).param("status", new String[]{"ALL"}).param("fileName", new String[]{"fileName"}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void computeRewardsByPeriodAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/period/compute", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeRewardsByPeriodSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/period/compute", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeRewardsByPeriodAdmin() throws Exception {
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        RewardPeriod rewardPeriod = new RewardPeriod();
        RewardReport rewardReport = new RewardReport();
        rewardReport.setPeriod(rewardPeriod);
        Mockito.when((Object)this.rewardReportService.computeRewards((LocalDate)Mockito.any(LocalDate.class))).thenReturn((Object)rewardReport);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/period/compute", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(rewardPeriod)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void computeDistributionForecastAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/forecast", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeDistributionForecastSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/forecast", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeDistributionForecastAdmin() throws Exception {
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        RewardPeriod rewardPeriod = new RewardPeriod();
        RewardReport rewardReport = new RewardReport();
        rewardReport.setPeriod(rewardPeriod);
        Mockito.when((Object)this.rewardReportService.computeRewards((LocalDate)Mockito.any(LocalDate.class))).thenReturn((Object)rewardReport);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/forecast", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(rewardPeriod)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void computeRewardsByUserAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute/user", (Object[])new Object[0]).param("date", new String[]{"2024-09-10"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void computeRewardsByUserSimpleUser() throws Exception {
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        RewardPeriod rewardPeriod = new RewardPeriod();
        RewardReport rewardReport = new RewardReport();
        rewardReport.setPeriod(rewardPeriod);
        Mockito.when((Object)this.rewardReportService.computeRewardsByUser((LocalDate)Mockito.any(LocalDate.class), Mockito.anyLong())).thenReturn((Object)rewardReport);
        try (MockedStatic walletUtilsMockedStatic = Mockito.mockStatic(WalletUtils.class);){
            walletUtilsMockedStatic.when(WalletUtils::getCurrentUserIdentityId).thenReturn((Object)1L);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute/user", (Object[])new Object[0]).param("date", new String[]{"2024-09-10"}).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
            response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/compute/user", (Object[])new Object[0]).param("date", new String[]{""}).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        }
    }

    @Test
    void sendRewardsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/send", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void sendRewardsSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/send", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void sendRewardsAdmin() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/send", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testAdminUser()));
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).sendRewards((LocalDate)Mockito.any(LocalDate.class), Mockito.anyString());
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((RewardReportService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.rewardReportService)).sendRewards((LocalDate)Mockito.any(LocalDate.class), Mockito.anyString());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/reward/send", (Object[])new Object[0]).content(TestRewardReportREST.asJsonString(this.rewardPeriod())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    void listRewardsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/list", (Object[])new Object[0]).param("limit", new String[]{"10"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void listRewardsSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/list", (Object[])new Object[0]).param("limit", new String[]{"10"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getRewardReportPeriodsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/periods", (Object[])new Object[0]).param("from", new String[]{"0"}).param("to", new String[]{"10"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getRewardReportPeriodsSimpleUser() throws Exception {
        Mockito.when((Object)this.rewardReportService.findRewardReportPeriods(Mockito.anyString(), (Pageable)Mockito.any(Pageable.class))).thenReturn((Object)new PageImpl(List.of(this.newRewardPeriod())));
        Mockito.when((Object)this.rewardReportService.findRewardPeriodsBetween(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong(), (Pageable)Mockito.any(Pageable.class))).thenReturn((Object)new PageImpl(List.of(this.newRewardPeriod())));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/periods", (Object[])new Object[0]).param("from", new String[]{"0"}).param("to", new String[]{"0"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/periods", (Object[])new Object[0]).param("from", new String[]{"11211"}).param("to", new String[]{"225255"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        Mockito.when((Object)this.rewardReportService.findRewardReportPeriods(Mockito.anyString(), (Pageable)Mockito.any(Pageable.class))).thenThrow(new Throwable[]{new IllegalAccessException("Access denied")});
        Mockito.when((Object)this.rewardReportService.findRewardPeriodsBetween(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong(), (Pageable)Mockito.any(Pageable.class))).thenThrow(new Throwable[]{new IllegalAccessException("Access denied")});
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/periods", (Object[])new Object[0]).param("from", new String[]{"11211"}).param("to", new String[]{"225255"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    void countRewardsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/countRewards", (Object[])new Object[0]).param("userId", new String[]{"1"}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void countRewardsSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/reward/countRewards", (Object[])new Object[0]).param("userId", new String[]{"1"}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private RequestPostProcessor testAdminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)ADMIN_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("rewarding")});
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private RewardPeriod newRewardPeriod() {
        return new RewardPeriod();
    }

    private RewardPeriod rewardPeriod() {
        return new RewardPeriod(RewardPeriodType.WEEK, ZoneId.systemDefault().getId(), 1725832800L, 1726437600L);
    }

    private WalletReward walletReward() {
        return new WalletReward(1L, new Wallet(), new TransactionDetail(), 1L, 100.0, 40.0, this.rewardPeriod(), 1);
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

