/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.listener;

import io.meeds.wallet.reward.listener.TransactionReplacedListener;
import io.meeds.wallet.reward.service.RewardReportService;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={TransactionReplacedListener.class})
class TransactionReplacedListenerTest {
    private static final String EVENT_NAME = "exo.wallet.transaction.replaced";
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private RewardReportService rewardReportService;
    @MockBean
    private Event<Object, Map<String, String>> event;
    @Autowired
    private TransactionReplacedListener transactionReplacedListener;

    TransactionReplacedListenerTest() {
    }

    @BeforeEach
    void setUp() {
        this.transactionReplacedListener.init();
    }

    @Test
    void testInit() {
        ((ListenerService)Mockito.verify((Object)this.listenerService)).addListener(EVENT_NAME, (ListenerBase)this.transactionReplacedListener);
    }

    @Test
    void testOnEvent() {
        HashMap<String, String> transactionData = new HashMap<String, String>();
        transactionData.put("oldHash", "oldHashValue");
        transactionData.put("hash", "newHashValue");
        Mockito.when((Object)((Map)this.event.getData())).thenReturn(transactionData);
        this.transactionReplacedListener.onEvent(this.event);
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService)).replaceRewardTransactions("oldHashValue", "newHashValue");
    }
}

