/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.scheduling;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.reward.scheduling.task.RewardReportUpdateTask;
import io.meeds.wallet.reward.service.RewardReportService;
import java.util.HashMap;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={RewardReportUpdateTask.class})
class RewardReportUpdateTaskTest {
    @MockBean
    private RewardReportService rewardReportService;
    @Autowired
    private RewardReportUpdateTask rewardReportUpdateTask;

    RewardReportUpdateTaskTest() {
    }

    @Test
    void executeWhenRewardSettingChanged() {
        RewardPeriod rewardPeriod = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        HashMap<Long, Boolean> rewardSettingChanged = new HashMap<Long, Boolean>();
        rewardSettingChanged.put(1L, true);
        rewardSettingChanged.put(2L, false);
        Mockito.when((Object)this.rewardReportService.getRewardSettingChanged()).thenReturn(rewardSettingChanged);
        Mockito.when((Object)this.rewardReportService.getRewardPeriodById(1L)).thenReturn((Object)rewardPeriod);
        this.rewardReportUpdateTask.execute();
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).getReport(rewardPeriod);
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).getRewardPeriodById(1L);
    }

    @Test
    void executeWhenRewardSettingNotChanged() {
        HashMap<Long, Boolean> rewardSettingChanged = new HashMap<Long, Boolean>();
        rewardSettingChanged.put(1L, false);
        Mockito.when((Object)this.rewardReportService.getRewardSettingChanged()).thenReturn(rewardSettingChanged);
        this.rewardReportUpdateTask.execute();
        ((RewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.never())).getReport((RewardPeriod)Mockito.any());
    }
}

