/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import java.util.Collections;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.listener.WalletDeletedListener;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.test.BaseWalletTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WalletDeletedListenerTest
extends BaseWalletTest {
    private static final String ADDRESS = "address";
    @Mock
    private WalletTransactionService transactionService;
    @Mock
    private ListenerService listenerService;
    private WalletDeletedListener listener;
    private Event<Wallet, String> event;
    private Wallet wallet;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.wallet = new Wallet();
        this.wallet.setAddress(ADDRESS);
        this.listener = new WalletDeletedListener(this.transactionService);
        this.event = new Event("exo.wallet.deleted", (Object)this.wallet, null);
    }

    @Test
    public void testOnEventNoTransactionSave() throws Exception {
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).saveTransactionDetail((TransactionDetail)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testOnEventCancelTransactionsNotSent() throws Exception {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setPending(true);
        Mockito.when((Object)this.transactionService.getPendingWalletTransactionsNotSent(ADDRESS)).thenReturn(Collections.singletonList(transactionDetail));
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).saveTransactionDetail((TransactionDetail)ArgumentMatchers.argThat(transaction -> !transaction.isPending()), ArgumentMatchers.eq((boolean)true));
    }
}

