/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.permlink.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.utils.WalletUtils;

public class WalletPermanentLinkPlugin
implements PermanentLinkPlugin {
    private static final String OBJECT_TYPE = "wallet";
    public static final String URL_FORMAT = "/portal/%s/wallet";
    private SpaceService spaceService;
    private WalletAccountService walletAccountService;
    private UserPortalConfigService portalConfigService;

    public WalletPermanentLinkPlugin(SpaceService spaceService, WalletAccountService walletAccountService, UserPortalConfigService portalConfigService) {
        this.spaceService = spaceService;
        this.walletAccountService = walletAccountService;
        this.portalConfigService = portalConfigService;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
        String identityId = object.getObjectId();
        Wallet wallet = this.walletAccountService.getWalletByIdentityId(Long.parseLong(identityId));
        return wallet != null && WalletUtils.canAccessWallet((Wallet)wallet, (String)identity.getUserId());
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        Object url;
        String identityId = object.getObjectId();
        Wallet wallet = this.walletAccountService.getWalletByIdentityId(Long.parseLong(identityId));
        Object object2 = url = WalletType.isSpace((String)wallet.getType()) ? this.getSpaceUrl(this.spaceService.getSpaceByPrettyName(wallet.getName())) : this.getProfileUrl();
        if (object.getParameters() != null && object.getParameters().containsKey("transactionHash")) {
            url = (String)url + "?hash=" + (String)object.getParameters().get("transactionHash");
        }
        return url;
    }

    public String getSpaceUrl(Space space) {
        return String.format("/portal/s/%s/SpaceWallet", space.getId());
    }

    public String getProfileUrl() {
        return String.format(URL_FORMAT, this.portalConfigService.getMetaPortal());
    }
}

