/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.storage;

import io.meeds.wallet.model.WalletAddressLabel;
import io.meeds.wallet.storage.AddressLabelStorage;
import io.meeds.wallet.test.BaseWalletTest;
import java.util.Set;
import org.junit.Test;

public class AddressLabelStorageTest
extends BaseWalletTest {
    private long identityId = 1L;
    private String labelText = "label";

    @Test
    public void testServiceInstantiated() {
        AddressLabelStorage addressLabelStorage = this.getService(AddressLabelStorage.class);
        AddressLabelStorageTest.assertNotNull((Object)addressLabelStorage);
        Set allLabels = addressLabelStorage.getAllLabels();
        AddressLabelStorageTest.assertNotNull((String)"Returned labels list shouldn't be null", (Object)allLabels);
        AddressLabelStorageTest.assertEquals((String)"Returned labels should be empty", (int)0, (int)allLabels.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveLabel() {
        AddressLabelStorage addressLabelStorage = this.getService(AddressLabelStorage.class);
        try {
            addressLabelStorage.saveLabel(null);
            AddressLabelStorageTest.fail((String)"Saving a null label should throws an exeption");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WalletAddressLabel walletAddressLabel = new WalletAddressLabel();
        walletAddressLabel.setAddress("0x1111111111111111111111111111111111111111");
        walletAddressLabel.setIdentityId(this.identityId);
        walletAddressLabel.setLabel(this.labelText);
        walletAddressLabel = addressLabelStorage.saveLabel(walletAddressLabel);
        this.entitiesToClean.add(walletAddressLabel);
        this.checkLabelContent(walletAddressLabel, this.identityId, this.labelText, "0x1111111111111111111111111111111111111111");
        walletAddressLabel = addressLabelStorage.getLabel(walletAddressLabel.getId());
        this.checkLabelContent(walletAddressLabel, this.identityId, this.labelText, "0x1111111111111111111111111111111111111111");
        Set allLabels = addressLabelStorage.getAllLabels();
        AddressLabelStorageTest.assertNotNull((String)"Returned labels list shouldn't be null", (Object)allLabels);
        AddressLabelStorageTest.assertEquals((String)"Returned labels should return 1 label", (int)1, (int)allLabels.size());
        walletAddressLabel = (WalletAddressLabel)addressLabelStorage.getAllLabels().iterator().next();
        this.checkLabelContent(walletAddressLabel, this.identityId, this.labelText, "0x1111111111111111111111111111111111111111");
        this.labelText = "new label";
        try {
            walletAddressLabel.setLabel(this.labelText);
            walletAddressLabel = addressLabelStorage.saveLabel(walletAddressLabel);
            this.checkLabelContent(walletAddressLabel, this.identityId, this.labelText, "0x1111111111111111111111111111111111111111");
            allLabels = addressLabelStorage.getAllLabels();
            AddressLabelStorageTest.assertEquals((String)"Returned labels should return 1 label", (int)1, (int)allLabels.size());
            walletAddressLabel = (WalletAddressLabel)addressLabelStorage.getAllLabels().iterator().next();
            this.checkLabelContent(walletAddressLabel, this.identityId, this.labelText, "0x1111111111111111111111111111111111111111");
        }
        finally {
            this.labelText = "label";
        }
    }

    @Test
    public void testRemoveLabel() {
        AddressLabelStorage addressLabelStorage = this.getService(AddressLabelStorage.class);
        WalletAddressLabel walletAddressLabel = new WalletAddressLabel();
        walletAddressLabel.setAddress("0x1111111111111111111111111111111111111111");
        walletAddressLabel.setIdentityId(this.identityId);
        walletAddressLabel.setLabel(this.labelText);
        walletAddressLabel = addressLabelStorage.saveLabel(walletAddressLabel);
        AddressLabelStorageTest.assertNotNull((Object)walletAddressLabel);
        this.entitiesToClean.add(walletAddressLabel);
        this.checkLabelContent(walletAddressLabel, this.identityId, this.labelText, "0x1111111111111111111111111111111111111111");
        addressLabelStorage.removeLabel(walletAddressLabel);
        this.entitiesToClean.remove(walletAddressLabel);
        Set allLabels = addressLabelStorage.getAllLabels();
        AddressLabelStorageTest.assertNotNull((String)"Returned labels list shouldn't be null", (Object)allLabels);
        AddressLabelStorageTest.assertEquals((String)"Returned labels should be empty", (int)0, (int)allLabels.size());
        walletAddressLabel = addressLabelStorage.getLabel(walletAddressLabel.getId());
        AddressLabelStorageTest.assertNull((String)"Address label should have been deleted", (Object)walletAddressLabel);
    }

    private void checkLabelContent(WalletAddressLabel walletAddressLabel, long identityId, String labelText, String address) {
        AddressLabelStorageTest.assertNotNull((String)"Returned WalletAddress shouldn't be null after saving it", (Object)walletAddressLabel);
        AddressLabelStorageTest.assertTrue((String)"Returned WalletAddress should have an id", (walletAddressLabel.getId() > 0L ? 1 : 0) != 0);
        AddressLabelStorageTest.assertEquals((String)"Returned WalletAddress should have an id", (long)identityId, (long)walletAddressLabel.getIdentityId());
        AddressLabelStorageTest.assertEquals((String)"Returned WalletAddress should have an id", (String)labelText, (String)walletAddressLabel.getLabel());
        AddressLabelStorageTest.assertEquals((String)"Returned WalletAddress should have an id", (String)address, (String)walletAddressLabel.getAddress());
    }
}

