/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.dao;

import io.meeds.wallet.dao.WalletAccountDAO;
import io.meeds.wallet.entity.WalletEntity;
import io.meeds.wallet.model.WalletType;
import io.meeds.wallet.test.BaseWalletTest;
import java.util.Collections;
import java.util.List;
import org.junit.Test;

public class WalletAccountDAOTest
extends BaseWalletTest {
    @Test
    public void testServiceInstantiated() {
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        WalletAccountDAOTest.assertNotNull((Object)walletAccountDAO);
        List allWallets = walletAccountDAO.findAll();
        WalletAccountDAOTest.assertNotNull((String)"Returned wallets list shouldn't be null", (Object)allWallets);
        WalletAccountDAOTest.assertEquals((String)"Returned wallets should be empty", (int)0, (int)allWallets.size());
    }

    @Test
    public void testWalletMassiveDeletionDeny() {
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        try {
            walletAccountDAO.deleteAll();
            WalletAccountDAOTest.fail((String)"Shouldn't be able to delete all wallets");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            walletAccountDAO.deleteAll(Collections.emptyList());
            WalletAccountDAOTest.fail((String)"Shouldn't be able to delete multiple wallets in single operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWalletByAddress() {
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        WalletEntity walletEntity = new WalletEntity();
        String address = "0xc76987D43b77C45d51653b6eB110b9174aCCE8fb";
        walletEntity.setId(Long.valueOf(1L));
        walletEntity.setAddress(address);
        walletEntity.setPassPhrase("passphrase");
        walletEntity.setType(WalletType.USER);
        walletEntity = (WalletEntity)walletAccountDAO.create((Object)walletEntity);
        this.entitiesToClean.add(walletEntity);
        walletEntity = walletAccountDAO.findByAddress(address);
        WalletAccountDAOTest.assertNotNull((String)"Can't find wallet by address", (Object)walletEntity);
    }
}

