/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.blockchain.listener;

import io.meeds.wallet.blockchain.listener.TransactionSentToBlockchainListener;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.service.WalletTransactionService;
import io.meeds.wallet.test.BaseWalletTest;
import org.exoplatform.services.listener.Event;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionSentToBlockchainListenerTest
extends BaseWalletTest {
    @Mock
    private WalletTransactionService walletTransactionService;
    @Mock
    private BlockchainTransactionService blockchainTransactionService;
    private TransactionSentToBlockchainListener listener;
    private Event<Object, TransactionDetail> event;
    private TransactionDetail transactionDetail = new TransactionDetail();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.event = new Event("exo.wallet.transaction.minedAndUpdated", null, (Object)this.transactionDetail);
        this.listener = new TransactionSentToBlockchainListener(this.walletTransactionService, this.blockchainTransactionService);
    }

    @Test
    public void testOnEventWhenNoPendingTransactions() throws Exception {
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.never())).startWatchingBlockchain();
    }

    @Test
    public void testOnEventWhenHavingPendingTransactions() throws Exception {
        Mockito.when((Object)this.walletTransactionService.countContractPendingTransactionsSent()).thenReturn((Object)1L);
        this.listener.onEvent(this.event);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).startWatchingBlockchain();
    }
}

