/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.blockchain.listener;

import io.meeds.wallet.blockchain.listener.TransactionWithNonceVerifierListener;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.service.WalletTransactionService;
import io.meeds.wallet.test.BaseWalletTest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionWithNonceVerifierListenerTest
extends BaseWalletTest {
    private static final int NONCE = 12;
    @Mock
    private WalletTransactionService transactionService;
    @Mock
    private BlockchainTransactionService blockchainTransactionService;
    private TransactionWithNonceVerifierListener listener;
    private Event<Object, Map<String, Object>> event;
    private TransactionDetail transactionDetail;
    private String hash = "transactionHash";
    private String fromAddress = "fromAddress";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new TransactionWithNonceVerifierListener(this.blockchainTransactionService, this.transactionService);
        this.event = new Event("exo.wallet.transaction.mined", null, Collections.singletonMap("hash", this.hash));
        this.transactionDetail = new TransactionDetail();
        this.transactionDetail.setHash(this.hash);
        this.transactionDetail.setFrom(this.fromAddress);
        this.transactionDetail.setNonce(12L);
    }

    @Test
    public void testOnEventWhenTransactionIsNull() throws Exception {
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).getTransactionByHash(this.hash);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.blockchainTransactionService});
    }

    @Test
    public void testOnEventWhenTransactionIsPending() throws Exception {
        Mockito.when((Object)this.transactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setPending(true);
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.blockchainTransactionService});
    }

    @Test
    public void testOnEventWhenTransactionIsNotForContract() throws Exception {
        Mockito.when((Object)this.transactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.blockchainTransactionService});
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.never())).getPendingWalletTransactionsSent((String)ArgumentMatchers.any());
    }

    @Test
    public void testOnEventWhenTransactionIsForContractTransfer() throws Exception {
        Mockito.when((Object)this.transactionService.getTransactionByHash(this.hash)).thenReturn((Object)this.transactionDetail);
        this.transactionDetail.setContractMethodName("transfer");
        this.transactionDetail.setFromWallet(new Wallet());
        this.transactionDetail.getFromWallet().setAddress(this.fromAddress);
        List<TransactionDetail> fromTransactions = Collections.singletonList(new TransactionDetail());
        fromTransactions.get(0).setHash("from1");
        fromTransactions.get(0).setNonce(11L);
        Mockito.when((Object)this.transactionService.getPendingWalletTransactionsSent(this.fromAddress)).thenReturn(fromTransactions);
        this.listener.onEvent(this.event);
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).getPendingWalletTransactionsSent((String)ArgumentMatchers.any());
        ((WalletTransactionService)Mockito.verify((Object)this.transactionService, (VerificationMode)Mockito.times((int)1))).getPendingWalletTransactionsSent(this.fromAddress);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).addTransactionToRefreshFromBlockchain(fromTransactions.get(0));
    }
}

