/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.storage;

import io.meeds.wallet.dao.WalletAccountBackupDAO;
import io.meeds.wallet.entity.WalletBackupEntity;
import io.meeds.wallet.entity.WalletEntity;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletProvider;
import io.meeds.wallet.model.WalletState;
import io.meeds.wallet.storage.WalletStorage;
import io.meeds.wallet.test.BaseWalletTest;
import io.meeds.wallet.utils.WalletUtils;
import java.util.Set;
import org.junit.Test;

public class WalletStorageTest
extends BaseWalletTest {
    private static final String WALLET_PRIVATE_KEY_CONTENT = "Wallet-Private-Key-Encrypted-With-Password";

    @Test
    public void testServiceInstantiated() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        WalletStorageTest.assertNotNull((Object)walletStorage);
        long walletsCount = walletStorage.getWalletsCount();
        WalletStorageTest.assertEquals((String)"Returned wallets count should be 0", (long)0L, (long)walletsCount);
    }

    @Test
    public void testNoExceptionThrownOnConstructor() {
        try {
            new WalletStorage(null, null, null, null, null);
        }
        catch (Exception e) {
            WalletStorageTest.fail((String)"Shouldn't throw an exception on constructor, even if all parameters are null");
        }
    }

    @Test
    public void testSaveWallet() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        this.checkWalletContent(wallet, 1L, "0x1111111111111111111111111111111111111111", "passphrase", INITIALIZATION_STATE, true);
        String newInitializationState = WalletState.DENIED.name();
        wallet.setInitializationState(newInitializationState);
        wallet = walletStorage.saveWallet(wallet, false);
        this.checkWalletContent(wallet, 1L, "0x1111111111111111111111111111111111111111", "passphrase", newInitializationState, true);
    }

    @Test
    public void testSaveWalletBackupState() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        WalletStorageTest.assertFalse((boolean)wallet.isBackedUp());
        wallet = walletStorage.saveWallet(wallet, true);
        this.entitiesToClean.add(wallet);
        WalletStorageTest.assertNotNull((Object)wallet);
        WalletStorageTest.assertFalse((boolean)wallet.isBackedUp());
        wallet = walletStorage.saveWalletBackupState(wallet.getTechnicalId(), true);
        WalletStorageTest.assertTrue((boolean)wallet.isBackedUp());
        wallet = walletStorage.saveWalletBackupState(wallet.getTechnicalId(), false);
        WalletStorageTest.assertFalse((boolean)wallet.isBackedUp());
    }

    @Test
    public void testRemoveWallet() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        walletStorage.removeWallet(1L);
        Set listWallets = walletStorage.listWallets();
        WalletStorageTest.assertNotNull((Object)listWallets);
        WalletStorageTest.assertEquals((int)0, (int)listWallets.size());
    }

    @Test
    public void testGetWalletByAddress() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        wallet = walletStorage.getWalletByAddress("0x1111111111111111111111111111111111111111", null);
        this.checkWalletContent(wallet, 1L, "0x1111111111111111111111111111111111111111", "passphrase", INITIALIZATION_STATE, true);
        wallet = walletStorage.getWalletByAddress("new-address", null);
        WalletStorageTest.assertNull((String)"Shouldn't find wallet with not recognized address", (Object)wallet);
    }

    @Test
    public void testGetWalletByIdentityId() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        wallet = walletStorage.getWalletByIdentityId(1L, null);
        this.checkWalletContent(wallet, 1L, "0x1111111111111111111111111111111111111111", "passphrase", INITIALIZATION_STATE, true);
        wallet = walletStorage.getWalletByIdentityId(1523L, null);
        WalletStorageTest.assertNull((Object)wallet);
    }

    @Test
    public void testListWallets() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Set listWallets = walletStorage.listWallets();
        WalletStorageTest.assertNotNull((Object)listWallets);
        WalletStorageTest.assertEquals((int)0, (int)listWallets.size());
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        listWallets = walletStorage.listWallets();
        WalletStorageTest.assertNotNull((Object)listWallets);
        WalletStorageTest.assertEquals((int)1, (int)listWallets.size());
        wallet = (Wallet)listWallets.iterator().next();
        this.checkWalletContent(wallet, 1L, "0x1111111111111111111111111111111111111111", "passphrase", INITIALIZATION_STATE, true);
    }

    @Test
    public void testSaveWalletPrivateKey() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        try {
            walletStorage.saveWalletPrivateKey(0L, WALLET_PRIVATE_KEY_CONTENT);
            WalletStorageTest.fail((String)"No wallet associated to 222 id, thus an exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            walletStorage.saveWalletPrivateKey(1L, null);
            WalletStorageTest.fail((String)"No wallet key content, thus an exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletStorage.saveWalletPrivateKey(wallet.getTechnicalId(), WALLET_PRIVATE_KEY_CONTENT);
        walletStorage.saveWalletPrivateKey(wallet.getTechnicalId(), WALLET_PRIVATE_KEY_CONTENT);
        wallet = walletStorage.getWalletByIdentityId(1L, null);
        WalletStorageTest.assertTrue((boolean)wallet.isHasPrivateKey());
        String content = walletStorage.getWalletPrivateKey(1L);
        WalletStorageTest.assertEquals((String)WALLET_PRIVATE_KEY_CONTENT, (String)content);
        String newContent = "Wallet-Private-Key-Encrypted-With-Password1";
        walletStorage.saveWalletPrivateKey(wallet.getTechnicalId(), newContent);
        content = walletStorage.getWalletPrivateKey(1L);
        WalletStorageTest.assertEquals((String)newContent, (String)content);
        wallet = walletStorage.getWalletByIdentityId(1L, null);
        WalletStorageTest.assertTrue((boolean)wallet.isHasPrivateKey());
    }

    @Test
    public void testGetWalletPrivateKey() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        long walletId = wallet.getTechnicalId();
        walletStorage.saveWalletPrivateKey(walletId, WALLET_PRIVATE_KEY_CONTENT);
        String content = walletStorage.getWalletPrivateKey(walletId);
        WalletStorageTest.assertEquals((String)WALLET_PRIVATE_KEY_CONTENT, (String)content);
    }

    @Test
    public void testRemoveWalletPrivateKey() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        long walletId = wallet.getTechnicalId();
        walletStorage.saveWalletPrivateKey(walletId, WALLET_PRIVATE_KEY_CONTENT);
        String content = walletStorage.getWalletPrivateKey(walletId);
        WalletStorageTest.assertNotNull((Object)content);
        wallet = walletStorage.getWalletByIdentityId(walletId, null);
        WalletStorageTest.assertTrue((boolean)wallet.isHasPrivateKey());
        walletStorage.removeWalletPrivateKey(walletId);
        content = walletStorage.getWalletPrivateKey(walletId);
        WalletStorageTest.assertNull((Object)content);
        wallet = walletStorage.getWalletByIdentityId(walletId, null);
        WalletStorageTest.assertFalse((boolean)wallet.isHasPrivateKey());
    }

    @Test
    public void testSaveWalletBlockchainState() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        String contractAddress = WalletUtils.getContractAddress();
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        walletStorage.retrieveWalletBlockchainState(wallet, contractAddress);
        WalletStorageTest.assertNotNull((Object)wallet);
        WalletStorageTest.assertNull((Object)wallet.getEtherBalance());
        this.entitiesToClean.add(wallet);
        try {
            walletStorage.saveWalletBlockchainState(wallet, null);
            WalletStorageTest.fail((String)"should throw exception when contract address is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            walletStorage.saveWalletBlockchainState(null, contractAddress);
            WalletStorageTest.fail((String)"should throw exception when wallet is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Wallet newWallet = this.newWallet();
        newWallet.setTechnicalId(0L);
        try {
            walletStorage.saveWalletBlockchainState(newWallet, contractAddress);
            WalletStorageTest.fail((String)"should throw exception when wallet id is 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        walletStorage.saveWalletBlockchainState(wallet, contractAddress);
        wallet = walletStorage.getWalletByIdentityId(wallet.getTechnicalId(), contractAddress);
        walletStorage.retrieveWalletBlockchainState(wallet, contractAddress);
        WalletStorageTest.assertNotNull((Object)wallet);
        WalletStorageTest.assertNotNull((Object)wallet.getEtherBalance());
        WalletStorageTest.assertEquals((double)0.0, (double)wallet.getEtherBalance(), (double)0.0);
        wallet.setTokenBalance(Double.valueOf(2.0));
        wallet.setEtherBalance(Double.valueOf(4.0));
        wallet.setIsInitialized(Boolean.valueOf(true));
        walletStorage.saveWalletBlockchainState(wallet, contractAddress);
        Wallet storedWallet = walletStorage.getWalletByIdentityId(wallet.getTechnicalId(), contractAddress);
        walletStorage.retrieveWalletBlockchainState(storedWallet, contractAddress);
        WalletStorageTest.assertEquals((double)wallet.getEtherBalance(), (double)storedWallet.getEtherBalance(), (double)0.0);
        WalletStorageTest.assertEquals((double)wallet.getTokenBalance(), (double)storedWallet.getTokenBalance(), (double)0.0);
        WalletStorageTest.assertEquals((Object)wallet.getIsInitialized(), (Object)storedWallet.getIsInitialized());
        this.entitiesToClean.add(storedWallet);
    }

    @Test
    public void testHasWallet() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        Boolean hasWallet = walletStorage.hasWallet(1L);
        WalletStorageTest.assertFalse((boolean)hasWallet);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        hasWallet = walletStorage.hasWallet(1L);
        WalletStorageTest.assertTrue((boolean)hasWallet);
    }

    @Test
    public void testHasWalletBackup() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        Boolean hasBackupWallet = walletStorage.hasWalletBackup(1L);
        WalletStorageTest.assertFalse((boolean)hasBackupWallet);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        this.entitiesToClean.add(wallet);
        WalletEntity walletEntity = new WalletEntity();
        walletEntity.setId(Long.valueOf(wallet.getTechnicalId()));
        walletEntity.setAddress(wallet.getAddress());
        walletEntity.setPassPhrase(wallet.getPassPhrase());
        walletEntity.setEnabled(wallet.isEnabled());
        walletEntity.setInitializationState(WalletState.valueOf((String)wallet.getInitializationState()));
        walletEntity.setProvider(WalletProvider.valueOf((String)wallet.getProvider()));
        WalletBackupEntity walletBackup = new WalletBackupEntity();
        walletBackup.setAddress(wallet.getAddress());
        walletBackup.setWallet(walletEntity);
        walletBackup = (WalletBackupEntity)walletAccountBackupDAO.create((Object)walletBackup);
        this.entitiesToClean.add(walletBackup);
        hasBackupWallet = walletStorage.hasWalletBackup(1L);
        WalletStorageTest.assertTrue((boolean)hasBackupWallet);
    }

    @Test
    public void testSwitchToWalletProvider() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        walletStorage.switchToWalletProvider(wallet.getTechnicalId(), WalletProvider.METAMASK, "0x2222222222222222222222222222222222222222");
        wallet = walletStorage.getWalletByAddress("0x2222222222222222222222222222222222222222", null);
        WalletStorageTest.assertNotNull((Object)wallet);
        WalletStorageTest.assertEquals((String)"0x2222222222222222222222222222222222222222", (String)wallet.getAddress());
        WalletBackupEntity walletBackup = walletAccountBackupDAO.findByWalletId(wallet.getTechnicalId());
        WalletStorageTest.assertNotNull((Object)walletBackup);
        WalletStorageTest.assertEquals((String)"0x1111111111111111111111111111111111111111", (String)walletBackup.getAddress());
        this.entitiesToClean.add(walletBackup);
        this.entitiesToClean.add(wallet);
    }

    @Test
    public void testSwitchToInternalWallet() {
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        Wallet wallet = this.newWallet();
        wallet = walletStorage.saveWallet(wallet, true);
        WalletStorageTest.assertNotNull((Object)wallet);
        walletStorage.switchToWalletProvider(wallet.getTechnicalId(), WalletProvider.METAMASK, "0x2222222222222222222222222222222222222222");
        wallet = walletStorage.getWalletByAddress("0x2222222222222222222222222222222222222222", null);
        WalletStorageTest.assertNotNull((Object)wallet);
        WalletStorageTest.assertEquals((String)"0x2222222222222222222222222222222222222222", (String)wallet.getAddress());
        WalletBackupEntity walletBackup = walletAccountBackupDAO.findByWalletId(wallet.getTechnicalId());
        WalletStorageTest.assertNotNull((Object)walletBackup);
        WalletStorageTest.assertEquals((String)"0x1111111111111111111111111111111111111111", (String)walletBackup.getAddress());
        walletStorage.switchToInternalWallet(wallet.getTechnicalId());
        wallet = walletStorage.getWalletByAddress("0x1111111111111111111111111111111111111111", null);
        WalletStorageTest.assertEquals((String)WalletProvider.INTERNAL_WALLET.name(), (String)wallet.getProvider());
        walletBackup = walletAccountBackupDAO.findByWalletId(wallet.getTechnicalId());
        WalletStorageTest.assertNull((Object)walletBackup);
        this.entitiesToClean.add(wallet);
    }

    protected void checkWalletContent(Wallet wallet, long identityId, String address, String phrase, String initializationState, boolean isEnabled) {
        WalletStorageTest.assertEquals((long)identityId, (long)wallet.getTechnicalId());
        WalletStorageTest.assertEquals((String)address.toLowerCase(), (String)wallet.getAddress().toLowerCase());
        WalletStorageTest.assertEquals((String)phrase, (String)wallet.getPassPhrase());
        WalletStorageTest.assertEquals((String)initializationState, (String)wallet.getInitializationState());
        WalletStorageTest.assertEquals((boolean)isEnabled, (boolean)wallet.isEnabled());
    }
}

