/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.dao;

import io.meeds.wallet.dao.WalletTransactionDAO;
import io.meeds.wallet.entity.TransactionEntity;
import io.meeds.wallet.test.BaseWalletTest;
import io.meeds.wallet.utils.WalletUtils;
import java.time.ZonedDateTime;
import java.util.List;
import org.junit.Test;

public class WalletTransactionDAOTest
extends BaseWalletTest {
    @Test
    public void testServiceInstantiated() {
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        List allTransactions = walletTransactionDAO.findAll();
        WalletTransactionDAOTest.assertNotNull((String)"Returned transactions shouldn't be null", (Object)allTransactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned transactions list should be empty", (int)0, (int)allTransactions.size());
    }

    @Test
    public void testGetContractTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        this.generateTransactions("0xe9dfec7864af9e581a85ce3987d026be0f50aaaa", contractAddress, contractMethodName);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        List transactions = walletTransactionDAO.getContractTransactions(contractAddress, contractMethodName, 100);
        WalletTransactionDAOTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned contract transactions list count is not coherent", (int)10, (int)transactions.size());
        transactions = walletTransactionDAO.getContractTransactions(contractAddress, contractMethodName, 5);
        WalletTransactionDAOTest.assertEquals((String)"Returned contract transactions list count is not coherent", (int)5, (int)transactions.size());
        transactions = walletTransactionDAO.getContractTransactions(contractAddress, null, 100);
        WalletTransactionDAOTest.assertEquals((String)"Returned contract transactions list count with not method name is not coherent", (int)30, (int)transactions.size());
        transactions = walletTransactionDAO.getContractTransactions(contractAddress, null, 0);
        WalletTransactionDAOTest.assertEquals((String)"Returned contract transactions list count with limit = 0 is not coherent", (int)30, (int)transactions.size());
    }

    @Test
    public void testGetWalletTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        String firstAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        this.generateTransactions(firstAddress, contractAddress, contractMethodName);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        boolean includeAdministrationTransactions = true;
        boolean onlyPending = false;
        List transactions = walletTransactionDAO.getWalletTransactions(137L, firstAddress, null, null, 0, onlyPending, includeAdministrationTransactions);
        WalletTransactionDAOTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)60, (int)transactions.size());
        transactions = walletTransactionDAO.getWalletTransactions(137L, firstAddress, null, null, 20, onlyPending, includeAdministrationTransactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)20, (int)transactions.size());
        transactions = walletTransactionDAO.getWalletTransactions(137L, firstAddress, contractAddress, null, 0, onlyPending, includeAdministrationTransactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)30, (int)transactions.size());
        transactions = walletTransactionDAO.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, 0, onlyPending, includeAdministrationTransactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        onlyPending = true;
        transactions = walletTransactionDAO.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, 0, onlyPending, includeAdministrationTransactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
        includeAdministrationTransactions = false;
        transactions = walletTransactionDAO.getWalletTransactions(137L, firstAddress, contractAddress, contractMethodName, 0, onlyPending, includeAdministrationTransactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count is not coherent", (int)10, (int)transactions.size());
    }

    @Test
    public void testCountTransactionsByNonce() {
        String hashOfTX = "hashTX";
        this.createTransaction(hashOfTX, null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", true, true, 1L, true, System.currentTimeMillis());
        this.createTransaction(hashOfTX + "2", null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", true, true, 1L, true, System.currentTimeMillis());
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        WalletTransactionDAOTest.assertEquals((long)1L, (long)walletTransactionDAO.countPendingTransactionsWithSameNonce(WalletUtils.getNetworkId(), hashOfTX, "from", 1L));
    }

    @Test
    public void testGetPendingTransactionsByHash() {
        String hashOfTX1 = "hashTX1";
        String hashOfTX2 = "hashTX2";
        String hashOfTX3 = "hashTX3";
        this.createTransaction(hashOfTX1, null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", false, true, 1L, true, System.currentTimeMillis());
        this.createTransaction(hashOfTX2, null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", false, true, 1L, true, System.currentTimeMillis());
        this.createTransaction(hashOfTX3, null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", false, true, 1L, true, System.currentTimeMillis());
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        WalletTransactionDAOTest.assertNotNull((Object)walletTransactionDAO.getPendingTransactionByHash(hashOfTX1));
    }

    @Test
    public void testGetPendingTransactions() {
        String contractAddress = "0xe9dfec7864af9e581a85ce3987d026be0f509ac9";
        String contractMethodName = "transfer";
        String firstAddress = "0xe7dfec7864af9e581a85ce3987d026be0f509ac9";
        this.generateTransactions(firstAddress, contractAddress, contractMethodName);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        List transactions = walletTransactionDAO.getPendingWalletTransactionsNotSent(firstAddress, 137L);
        WalletTransactionDAOTest.assertNotNull((String)"Returned transactions list is null", (Object)transactions);
        WalletTransactionDAOTest.assertEquals((String)"Returned pending transactions list count on a network is not coherent", (int)10, (int)transactions.size());
        transactions = walletTransactionDAO.getPendingWalletTransactionsNotSent(firstAddress, 138L);
        WalletTransactionDAOTest.assertEquals((String)"Returned wallet transactions list count on a non existing network is not coherent", (int)0, (int)transactions.size());
    }

    @Test
    public void testGetTransactionByHash() {
        String hashOfTX = "hashTX";
        this.createTransaction(hashOfTX, null, null, 0.0, 0.0, "from", "to", "by", 0L, "label", "message", true, true, 1L, true, System.currentTimeMillis());
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        TransactionEntity transactionEntity = walletTransactionDAO.getTransactionByHash(hashOfTX);
        WalletTransactionDAOTest.assertNotNull((String)"Can't find previously saved transaction with given hash", (Object)transactionEntity);
        transactionEntity = walletTransactionDAO.getTransactionByHash("Fake Hash");
        WalletTransactionDAOTest.assertNull((String)"Shouldn't find a non existing transaction with fake hash", (Object)transactionEntity);
    }

    @Test
    public void testCountReceivedContractAmount() {
        String contractAddress = "contractAddress";
        String address = "address";
        String contractMethodName = "reward";
        this.generateTransactions(address, contractAddress, contractMethodName, -1000L);
        ZonedDateTime start = ZonedDateTime.now();
        this.generateTransactions(address, contractAddress, contractMethodName);
        ZonedDateTime end = ZonedDateTime.now().plusSeconds(1L);
        this.generateTransactions(address, contractAddress, contractMethodName, 3000L);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        double receivedAmount = walletTransactionDAO.countReceivedContractAmount(contractAddress, address, start, end);
        WalletTransactionDAOTest.assertEquals((String)"Received amount isn't coherent", (double)10.0, (double)receivedAmount, (double)0.0);
    }

    @Test
    public void testCountSentContractAmount() {
        String contractAddress = "contractAddress";
        String address = "address";
        String contractMethodName = "transfer";
        this.generateTransactions(address, contractAddress, contractMethodName, -1000L);
        ZonedDateTime start = ZonedDateTime.now();
        this.generateTransactions(address, contractAddress, contractMethodName);
        ZonedDateTime end = ZonedDateTime.now().plusSeconds(1L);
        this.generateTransactions(address, contractAddress, contractMethodName, 3000L);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        double sentAmount = walletTransactionDAO.countSentContractAmount(contractAddress, address, start, end);
        WalletTransactionDAOTest.assertEquals((String)"Sent amount isn't coherent", (double)10.0, (double)sentAmount, (double)0.0);
    }
}

