/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import org.exoplatform.common.http.client.StreamDemultiplexor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class SocketTimeout
extends Thread {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.commons.SocketTimeout");
    private boolean alive;
    TimeoutEntry[] time_list;
    int current;

    SocketTimeout(int secs) {
        block3: {
            super("SocketTimeout");
            this.alive = true;
            try {
                this.setDaemon(true);
            }
            catch (SecurityException se) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + se.getMessage()));
            }
        }
        this.setPriority(10);
        this.time_list = new TimeoutEntry[secs];
        for (int idx = 0; idx < secs; ++idx) {
            this.time_list[idx] = new TimeoutEntry(null);
            this.time_list[idx].next = this.time_list[idx].prev = this.time_list[idx];
        }
        this.current = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutEntry setTimeout(StreamDemultiplexor demux) {
        TimeoutEntry entry = new TimeoutEntry(demux);
        TimeoutEntry[] timeoutEntryArray = this.time_list;
        synchronized (this.time_list) {
            entry.next = this.time_list[this.current];
            entry.prev = this.time_list[this.current].prev;
            entry.prev.next = entry;
            entry.next.prev = entry;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        TimeoutEntry marked = null;
        block4: while (this.alive) {
            try {
                SocketTimeout.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TimeoutEntry[] timeoutEntryArray = this.time_list;
            // MONITORENTER : this.time_list
            TimeoutEntry entry = this.time_list[this.current].next;
            while (entry != this.time_list[this.current]) {
                entry.restart = false;
                entry = entry.next;
            }
            ++this.current;
            if (this.current >= this.time_list.length) {
                this.current = 0;
            }
            entry = this.time_list[this.current].next;
            while (entry != this.time_list[this.current]) {
                if (entry.alive && !entry.hyber) {
                    TimeoutEntry prev = entry.prev;
                    entry.kill();
                    entry.next = marked;
                    marked = entry;
                    entry = prev;
                }
                entry = entry.next;
            }
            // MONITOREXIT : timeoutEntryArray
            while (true) {
                if (marked == null) continue block4;
                marked.demux.markForClose(null);
                marked = marked.next;
            }
            break;
        }
        return;
    }

    public void kill() {
        this.alive = false;
    }

    class TimeoutEntry {
        boolean restart = false;
        boolean hyber = false;
        boolean alive = true;
        StreamDemultiplexor demux;
        TimeoutEntry next = null;
        TimeoutEntry prev = null;

        TimeoutEntry(StreamDemultiplexor demux) {
            this.demux = demux;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            this.hyber = false;
            if (this.restart) {
                return;
            }
            this.restart = true;
            TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
            synchronized (SocketTimeout.this.time_list) {
                if (!this.alive) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.next = SocketTimeout.this.time_list[SocketTimeout.this.current];
                this.prev = SocketTimeout.this.time_list[SocketTimeout.this.current].prev;
                this.prev.next = this;
                this.next.prev = this;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        void hyber() {
            if (this.alive) {
                this.hyber = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            this.alive = false;
            this.restart = false;
            this.hyber = false;
            TimeoutEntry[] timeoutEntryArray = SocketTimeout.this.time_list;
            synchronized (SocketTimeout.this.time_list) {
                if (this.prev == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.prev = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

