/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.ws.frameworks.json.BeanWithBookEnum;
import org.exoplatform.ws.frameworks.json.BeanWithSimpleEnum;
import org.exoplatform.ws.frameworks.json.Book;
import org.exoplatform.ws.frameworks.json.BookEnum;
import org.exoplatform.ws.frameworks.json.BookStorage;
import org.exoplatform.ws.frameworks.json.ClassTransfBean;
import org.exoplatform.ws.frameworks.json.JavaCollectionBean;
import org.exoplatform.ws.frameworks.json.JavaMapBean;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.StringEnum;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonTest;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class ObjectBuilderTest
extends JsonTest {
    private ArrayList<Book> sourceCollection;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sourceCollection = new ArrayList(3);
        this.sourceCollection.add(this.junitBook);
        this.sourceCollection.add(this.csharpBook);
        this.sourceCollection.add(this.javaScriptBook);
    }

    public void testCollectionArrayList() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getArrayList().size());
        ObjectBuilderTest.assertTrue((boolean)o.getArrayList().get(0).equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getArrayList().get(1).equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getArrayList().get(2).equals(this.sourceCollection.get(2)));
    }

    public void testCollectionVector() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getVector().size());
        ObjectBuilderTest.assertTrue((boolean)o.getVector().get(0).equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getVector().get(1).equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getVector().get(2).equals(this.sourceCollection.get(2)));
    }

    public void testCollectionLinkedList() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getLinkedList().size());
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedList().get(0).equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedList().get(1).equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedList().get(2).equals(this.sourceCollection.get(2)));
    }

    public void testCollectionLinkedHashSet() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getLinkedHashSet().size());
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashSet().contains(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashSet().contains(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashSet().contains(this.sourceCollection.get(2)));
    }

    public void testCollectionHashSet() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getHashSet().size());
        ObjectBuilderTest.assertTrue((boolean)o.getHashSet().contains(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashSet().contains(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashSet().contains(this.sourceCollection.get(2)));
    }

    public void testCollectionList() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getList().size());
        ObjectBuilderTest.assertTrue((boolean)o.getList().get(0).equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getList().get(1).equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getList().get(2).equals(this.sourceCollection.get(2)));
    }

    public void testCollectionSet() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getSet().size());
        ObjectBuilderTest.assertTrue((boolean)o.getSet().contains(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getSet().contains(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getSet().contains(this.sourceCollection.get(2)));
    }

    public void testCollectionQueue() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getQueue().size());
        ObjectBuilderTest.assertTrue((boolean)o.getQueue().contains(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getQueue().contains(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getQueue().contains(this.sourceCollection.get(2)));
    }

    public void testCollectionCollection() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getCollection().size());
        ObjectBuilderTest.assertTrue((boolean)o.getCollection().contains(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getCollection().contains(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getCollection().contains(this.sourceCollection.get(2)));
    }

    public void testCollectionArray() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("CollectionTest.txt")), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        JavaCollectionBean o = (JavaCollectionBean)ObjectBuilder.createObject(JavaCollectionBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)3, (int)o.getArray().length);
        ObjectBuilderTest.assertTrue((boolean)o.getArray()[0].equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getArray()[1].equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getArray()[2].equals(this.sourceCollection.get(2)));
    }

    public void testMap2() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("MapTest.txt")), (JsonHandler)handler);
        JsonValue jv = handler.getJsonObject();
        JavaMapBean o = (JavaMapBean)ObjectBuilder.createObject(JavaMapBean.class, (JsonValue)jv);
        ObjectBuilderTest.assertTrue((boolean)o.getMap().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getMap().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getMap().get("JavaScript").equals(this.sourceCollection.get(2)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashMap().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashMap().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashMap().get("JavaScript").equals(this.sourceCollection.get(2)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashtable().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashtable().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashtable().get("JavaScript").equals(this.sourceCollection.get(2)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashMap().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashMap().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashMap().get("JavaScript").equals(this.sourceCollection.get(2)));
    }

    public void testMapMap() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("MapTest.txt")), (JsonHandler)handler);
        JsonValue jv = handler.getJsonObject();
        JavaMapBean o = (JavaMapBean)ObjectBuilder.createObject(JavaMapBean.class, (JsonValue)jv);
        ObjectBuilderTest.assertTrue((boolean)o.getMap().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getMap().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getMap().get("JavaScript").equals(this.sourceCollection.get(2)));
    }

    public void testMapHashMap() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("MapTest.txt")), (JsonHandler)handler);
        JsonValue jv = handler.getJsonObject();
        JavaMapBean o = (JavaMapBean)ObjectBuilder.createObject(JavaMapBean.class, (JsonValue)jv);
        ObjectBuilderTest.assertTrue((boolean)o.getHashMap().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashMap().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashMap().get("JavaScript").equals(this.sourceCollection.get(2)));
    }

    public void testMapHashtable() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("MapTest.txt")), (JsonHandler)handler);
        JsonValue jv = handler.getJsonObject();
        JavaMapBean o = (JavaMapBean)ObjectBuilder.createObject(JavaMapBean.class, (JsonValue)jv);
        ObjectBuilderTest.assertTrue((boolean)o.getHashtable().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashtable().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getHashtable().get("JavaScript").equals(this.sourceCollection.get(2)));
    }

    public void testMapLinkedHashMap() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("MapTest.txt")), (JsonHandler)handler);
        JsonValue jv = handler.getJsonObject();
        JavaMapBean o = (JavaMapBean)ObjectBuilder.createObject(JavaMapBean.class, (JsonValue)jv);
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashMap().get("JUnit").equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashMap().get("C#").equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getLinkedHashMap().get("JavaScript").equals(this.sourceCollection.get(2)));
    }

    public void testBean() throws Exception {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("BookStorage.txt")), (JsonHandler)handler);
        JsonValue jv = handler.getJsonObject();
        BookStorage o = (BookStorage)ObjectBuilder.createObject(BookStorage.class, (JsonValue)jv);
        ObjectBuilderTest.assertTrue((boolean)o.getBooks().get(0).equals(this.sourceCollection.get(0)));
        ObjectBuilderTest.assertTrue((boolean)o.getBooks().get(1).equals(this.sourceCollection.get(1)));
        ObjectBuilderTest.assertTrue((boolean)o.getBooks().get(2).equals(this.sourceCollection.get(2)));
    }

    public void testEnumSerialization() throws Exception {
        String source = "{\"countList\":[\"ONE\",\"TWO\",\"TREE\"], \"name\":\"andrew\",\"count\":\"TREE\",\"counts\":[\"TWO\",\"TREE\"]}";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((InputStream)new ByteArrayInputStream(source.getBytes()), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        BeanWithSimpleEnum o = (BeanWithSimpleEnum)ObjectBuilder.createObject(BeanWithSimpleEnum.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((String)"andrew", (String)o.getName());
        ObjectBuilderTest.assertEquals((Object)((Object)StringEnum.TREE), (Object)((Object)o.getCount()));
        StringEnum[] counts = o.getCounts();
        ObjectBuilderTest.assertEquals((int)2, (int)counts.length);
        List<StringEnum> tmp = Arrays.asList(counts);
        ObjectBuilderTest.assertTrue((boolean)tmp.contains((Object)StringEnum.TWO));
        ObjectBuilderTest.assertTrue((boolean)tmp.contains((Object)StringEnum.TREE));
        tmp = o.getCountList();
        ObjectBuilderTest.assertEquals((int)3, (int)tmp.size());
        ObjectBuilderTest.assertTrue((boolean)tmp.contains((Object)StringEnum.ONE));
        ObjectBuilderTest.assertTrue((boolean)tmp.contains((Object)StringEnum.TWO));
        ObjectBuilderTest.assertTrue((boolean)tmp.contains((Object)StringEnum.TREE));
    }

    public void testEnumSerialization2() throws Exception {
        String source = "{\"book\":\"BEGINNING_C\"}";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((InputStream)new ByteArrayInputStream(source.getBytes()), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        BeanWithBookEnum o = (BeanWithBookEnum)ObjectBuilder.createObject(BeanWithBookEnum.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((Object)((Object)BookEnum.BEGINNING_C), (Object)((Object)o.getBook()));
    }

    public void testClass() throws Exception {
        String source = "{\"klass\":\"" + ForTestClass001.class.getName() + "\"}";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((InputStream)new ByteArrayInputStream(source.getBytes()), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        ClassTransfBean o = (ClassTransfBean)ObjectBuilder.createObject(ClassTransfBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals(ForTestClass001.class, (Object)o.getKlass());
    }

    public void testConvertFromStringValue() throws Exception {
        String jsonString = "{\"b\":\"1\", \"s\":\"2\" , \"i\":\"3\", \"l\":\"4\",\"f\":\"1.05\",\"d\":\"1.1\",\"bool\":\"true\"}";
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((InputStream)new ByteArrayInputStream(jsonString.getBytes()), (JsonHandler)handler);
        JsonValue jsonValue = handler.getJsonObject();
        ConvertFromStringValuBean o = (ConvertFromStringValuBean)ObjectBuilder.createObject(ConvertFromStringValuBean.class, (JsonValue)jsonValue);
        ObjectBuilderTest.assertEquals((int)1, (int)o.getB());
        ObjectBuilderTest.assertEquals((int)2, (int)o.getS());
        ObjectBuilderTest.assertEquals((int)3, (int)o.getI());
        ObjectBuilderTest.assertEquals((long)4L, (long)o.getL());
        ObjectBuilderTest.assertEquals((Object)Float.valueOf(1.05f), (Object)Float.valueOf(o.getF()));
        ObjectBuilderTest.assertEquals((Object)1.1, (Object)o.getD());
        ObjectBuilderTest.assertEquals((boolean)true, (boolean)o.isBool());
    }

    public static class ForTestClass001 {
    }

    public static class ConvertFromStringValuBean {
        private byte b;
        private short s;
        private int i;
        private long l;
        private float f;
        private double d;
        private boolean bool;

        public byte getB() {
            return this.b;
        }

        public void setB(byte b) {
            this.b = b;
        }

        public short getS() {
            return this.s;
        }

        public void setS(short s) {
            this.s = s;
        }

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public long getL() {
            return this.l;
        }

        public void setL(long l) {
            this.l = l;
        }

        public float getF() {
            return this.f;
        }

        public void setF(float f) {
            this.f = f;
        }

        public double getD() {
            return this.d;
        }

        public void setD(double d) {
            this.d = d;
        }

        public boolean isBool() {
            return this.bool;
        }

        public void setBool(boolean bool) {
            this.bool = bool;
        }
    }
}

