/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.generated.Book;
import org.exoplatform.services.rest.generated.MemberPrice;
import org.exoplatform.services.rest.generated.Price;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class JAXBEntityProviderTest
extends BaseTest {
    private byte[] data;
    private MediaType mediaType;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mediaType = new MediaType("application", "xml");
        this.data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><book send-by-post=\"true\"><title>Java and XML Data Binding</title><author>Brett McLaughlin</author><price>34.95</price><member-price currency=\"US\">26.56</member-price></book>".getBytes("UTF-8");
    }

    public static JAXBElement<Book> m(JAXBElement<Book> je) {
        return je;
    }

    public void testReadJAXBElement() throws Exception {
        Method m = ((Object)((Object)this)).getClass().getMethod("m", JAXBElement.class);
        JAXBEntityProviderTest.assertNotNull((Object)m);
        Class<?> type = m.getParameterTypes()[0];
        Type genericType = m.getGenericParameterTypes()[0];
        MessageBodyReader reader = this.providers.getMessageBodyReader(type, genericType, null, this.mediaType);
        JAXBEntityProviderTest.assertNotNull((Object)reader);
        JAXBEntityProviderTest.assertTrue((boolean)reader.isReadable(type, genericType, null, this.mediaType));
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Content-Length", (Object)("" + this.data.length));
        JAXBElement je = (JAXBElement)reader.readFrom(type, genericType, null, this.mediaType, (MultivaluedMap)h, (InputStream)in);
        JAXBEntityProviderTest.assertTrue((boolean)"Java and XML Data Binding".equals(((Book)je.getValue()).getTitle()));
    }

    public void testWriteJAXBElement() throws Exception {
        Method m = ((Object)((Object)this)).getClass().getMethod("m", JAXBElement.class);
        JAXBEntityProviderTest.assertNotNull((Object)m);
        Class<?> returnType = m.getReturnType();
        Type genericReturnType = m.getGenericReturnType();
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(returnType, genericReturnType, null, this.mediaType);
        JAXBEntityProviderTest.assertNotNull((Object)writer);
        JAXBEntityProviderTest.assertTrue((boolean)writer.isWriteable(returnType, genericReturnType, null, this.mediaType));
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller um = ctx.createUnmarshaller();
        StreamSource src = new StreamSource(new ByteArrayInputStream(this.data));
        JAXBElement je = um.unmarshal((Source)src, Book.class);
        writer.writeTo((Object)je, returnType, genericReturnType, null, this.mediaType, null, (OutputStream)new ByteArrayOutputStream());
    }

    public void testReadJAXBObject() throws Exception {
        MessageBodyReader prov = this.providers.getMessageBodyReader(Book.class, null, null, this.mediaType);
        JAXBEntityProviderTest.assertNotNull((Object)prov);
        JAXBEntityProviderTest.assertTrue((boolean)prov.isReadable(Book.class, Book.class, null, this.mediaType));
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Content-Length", (Object)("" + this.data.length));
        Book book = (Book)prov.readFrom(Book.class, Book.class, null, this.mediaType, (MultivaluedMap)h, (InputStream)new ByteArrayInputStream(this.data));
        JAXBEntityProviderTest.assertEquals((String)"Brett McLaughlin", (String)book.getAuthor());
    }

    public void testWriteJAXBObject() throws Exception {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(Book.class, null, null, this.mediaType);
        JAXBEntityProviderTest.assertNotNull((Object)writer);
        JAXBEntityProviderTest.assertTrue((boolean)writer.isWriteable(Book.class, Book.class, null, this.mediaType));
        Book book = new Book();
        book.setAuthor("William Shakespeare");
        book.setTitle("Hamlet");
        book.setPrice(JAXBEntityProviderTest.createPrice("EUR", Float.valueOf(15.15f)));
        book.setMemberPrice(JAXBEntityProviderTest.createMemberPrice("EUR", Float.valueOf(14.73f)));
        book.setSendByPost(true);
        writer.writeTo((Object)book, Book.class, Book.class, null, this.mediaType, null, (OutputStream)new ByteArrayOutputStream());
    }

    private static Price createPrice(String currency, Float value) {
        Price price = new Price();
        price.setCurrency(currency);
        price.setValue(new BigDecimal(value.floatValue()));
        return price;
    }

    private static MemberPrice createMemberPrice(String currency, Float value) {
        MemberPrice mprice = new MemberPrice();
        mprice.setCurrency(currency);
        mprice.setValue(new BigDecimal(value.floatValue()));
        return mprice;
    }
}

