/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;

public class ByteEntityProviderTest
extends BaseTest {
    public void testRead() throws Exception {
        MessageBodyReader reader = this.providers.getMessageBodyReader(byte[].class, null, null, MediaTypeHelper.DEFAULT_TYPE);
        ByteEntityProviderTest.assertNotNull((Object)reader);
        ByteEntityProviderTest.assertNotNull((Object)this.providers.getMessageBodyReader(byte[].class, null, null, null));
        ByteEntityProviderTest.assertTrue((boolean)reader.isReadable(byte[].class, null, null, null));
        byte[] data = new byte[16];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ByteEntityProviderTest.assertTrue((boolean)reader.isReadable(data.getClass(), null, null, null));
        byte[] result = (byte[])reader.readFrom(byte[].class, null, null, null, null, (InputStream)new ByteArrayInputStream(data));
        ByteEntityProviderTest.assertTrue((boolean)Arrays.equals(data, result));
    }

    public void testWrite() throws Exception {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(byte[].class, null, null, MediaTypeHelper.DEFAULT_TYPE);
        ByteEntityProviderTest.assertNotNull((Object)writer);
        ByteEntityProviderTest.assertNotNull((Object)this.providers.getMessageBodyWriter(byte[].class, null, null, null));
        ByteEntityProviderTest.assertTrue((boolean)writer.isWriteable(byte[].class, null, null, null));
        byte[] data = new byte[16];
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = (byte)i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTo((Object)data, byte[].class, null, null, null, null, (OutputStream)out);
        ByteEntityProviderTest.assertTrue((boolean)Arrays.equals(data, out.toByteArray()));
    }
}

