/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.provider.IOHelper;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.exoplatform.services.test.mock.MockHttpServletRequest;

public class ProviderContextParameterInjectionTest
extends BaseTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.providers.addMessageBodyReader(EntityProviderChecker.class);
        this.providers.addMessageBodyWriter(EntityProviderChecker.class);
        this.providers.addExceptionMapper(ExceptionMapperChecker.class);
        this.providers.addContextResolver(ContextResolverChecker.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void test0() throws Exception {
        this.registry(Resource1.class);
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest("/a/1", (InputStream)new ByteArrayInputStream("to be or not to be".getBytes()), 18, "POST", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("POST", "/a/1", "", null, "to be or not to be".getBytes(), envctx);
        ProviderContextParameterInjectionTest.assertEquals((String)"to be", (String)((MockEntity)resp.getEntity()).entity);
        httpRequest = new MockHttpServletRequest("/a/2", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        resp = this.launcher.service("GET", "/a/2", "", null, null, envctx);
        ProviderContextParameterInjectionTest.assertEquals((int)200, (int)resp.getStatus());
        httpRequest = new MockHttpServletRequest("/a/3", null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        resp = this.launcher.service("GET", "/a/3", "", null, null, envctx);
        ProviderContextParameterInjectionTest.assertEquals((int)200, (int)resp.getStatus());
        ProviderContextParameterInjectionTest.assertEquals((Object)"to be to not to be", (Object)resp.getEntity());
        this.unregistry(Resource1.class);
    }

    @Provider
    public static class EntityProviderChecker
    implements EntityProvider<MockEntity> {
        @Context
        private UriInfo uriInfo;
        @Context
        private Request request;
        @Context
        private HttpHeaders httpHeaders;
        @Context
        private Providers providers;
        @Context
        private HttpServletRequest httpRequest;

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.uriInfo != null && this.request != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null;
        }

        public MockEntity readFrom(Class<MockEntity> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            MockEntity me = new MockEntity();
            me.entity = IOHelper.readString((InputStream)entityStream, (String)"UTF-8");
            return me;
        }

        public long getSize(MockEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return 0L;
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.uriInfo != null && this.request != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null;
        }

        public void writeTo(MockEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            IOHelper.writeString((String)t.entity, (OutputStream)entityStream, (String)"UTF-8");
        }
    }

    @Provider
    public static class ExceptionMapperChecker
    implements ExceptionMapper<RuntimeException> {
        @Context
        private UriInfo uriInfo;
        @Context
        private Request request;
        @Context
        private HttpHeaders httpHeaders;
        @Context
        private Providers providers;
        @Context
        private HttpServletRequest httpRequest;

        public Response toResponse(RuntimeException exception) {
            if (this.uriInfo != null && this.request != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null) {
                return Response.status((int)200).build();
            }
            return Response.status((int)500).build();
        }
    }

    @Provider
    @Produces(value={"text/plain"})
    public static class ContextResolverChecker
    implements ContextResolver<String> {
        @Context
        private UriInfo uriInfo;
        @Context
        private Request request;
        @Context
        private HttpHeaders httpHeaders;
        @Context
        private Providers providers;
        @Context
        private HttpServletRequest httpRequest;

        public String getContext(Class<?> type) {
            if (this.uriInfo != null && this.request != null && this.httpHeaders != null && this.providers != null && this.httpRequest != null) {
                return "to be to not to be";
            }
            return null;
        }
    }

    @Path(value="a")
    public static class Resource1 {
        @Context
        private Providers providers;

        @POST
        @Path(value="1")
        public MockEntity m0(MockEntity me) {
            TestCase.assertNotNull((Object)me);
            TestCase.assertEquals((String)"to be or not to be", (String)me.entity);
            me.entity = "to be";
            return me;
        }

        @GET
        @Path(value="2")
        public void m1() {
            throw new RuntimeException();
        }

        @GET
        @Path(value="3")
        public String m2() {
            ContextResolver r = this.providers.getContextResolver(String.class, new MediaType("text", "plain"));
            return (String)r.getContext(String.class);
        }
    }

    public static class MockEntity {
        String entity;
    }
}

