/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.JAXBElement;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.generated.Book;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;

public class JAXBEntityTest
extends BaseTest {
    private static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><book send-by-post=\"true\"><title>Java and XML Data Binding</title><author>Brett McLaughlin</author><price currency=\"EUR\">34.95</price><member-price currency=\"EUR\">26.56</member-price></book>";

    public void testJAXBEntityParameter() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/xml");
        byte[] data = XML_DATA.getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        JAXBEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/a", "", (Map)h, data, null).getStatus());
        JAXBEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/b", "", (Map)h, data, null).getStatus());
        this.unregistry(r1);
    }

    public void testJAXBEntityReturn() throws Exception {
        Resource2 r2 = new Resource2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"accept", (Object)"application/xml");
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.launcher.service("GET", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JAXBEntityTest.assertEquals((int)200, (int)response.getStatus());
        JAXBEntityTest.assertEquals((String)"application/xml", (String)response.getContentType().toString());
        Book book = (Book)response.getEntity();
        JAXBEntityTest.assertEquals((String)"Hamlet", (String)book.getTitle());
        JAXBEntityTest.assertEquals((String)"William Shakespeare", (String)book.getAuthor());
        JAXBEntityTest.assertTrue((boolean)book.isSendByPost());
        writer = new ByteArrayContainerResponseWriter();
        response = this.launcher.service("POST", "/", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        JAXBEntityTest.assertEquals((int)200, (int)response.getStatus());
        JAXBEntityTest.assertEquals((String)"application/xml", (String)response.getContentType().toString());
        book = (Book)response.getEntity();
        JAXBEntityTest.assertEquals((String)"Hamlet\n", (String)book.getTitle());
        JAXBEntityTest.assertEquals((String)"William Shakespeare\n", (String)book.getAuthor());
        JAXBEntityTest.assertFalse((boolean)book.isSendByPost());
        this.unregistry(r2);
    }

    @Path(value="/")
    public static class Resource1 {
        @POST
        @Path(value="a")
        @Consumes(value={"application/xml"})
        public void m0(Book book) {
            TestCase.assertEquals((String)"Java and XML Data Binding", (String)book.getTitle());
            TestCase.assertEquals((String)"Brett McLaughlin", (String)book.getAuthor());
            TestCase.assertEquals((String)"EUR", (String)book.getPrice().getCurrency());
            TestCase.assertEquals((String)"EUR", (String)book.getMemberPrice().getCurrency());
            TestCase.assertTrue((boolean)book.isSendByPost());
        }

        @POST
        @Path(value="b")
        @Consumes(value={"application/xml"})
        public void m1(JAXBElement<Book> e) {
            Book book = (Book)e.getValue();
            TestCase.assertEquals((String)"Java and XML Data Binding", (String)book.getTitle());
            TestCase.assertEquals((String)"Brett McLaughlin", (String)book.getAuthor());
            TestCase.assertEquals((String)"EUR", (String)book.getPrice().getCurrency());
            TestCase.assertEquals((String)"EUR", (String)book.getMemberPrice().getCurrency());
            TestCase.assertTrue((boolean)book.isSendByPost());
        }
    }

    @Path(value="/")
    public static class Resource2 {
        @GET
        @Produces(value={"application/xml"})
        public Book m0() {
            Book book = new Book();
            book.setAuthor("William Shakespeare");
            book.setTitle("Hamlet");
            book.setSendByPost(true);
            return book;
        }

        @POST
        public Book m1() {
            Book book = new Book();
            book.setAuthor("William Shakespeare\n");
            book.setTitle("Hamlet\n");
            book.setSendByPost(false);
            return book;
        }
    }
}

