/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.wadl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.wadl.WadlProcessor;
import org.exoplatform.services.rest.wadl.research.Application;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WadlProcessorTest
extends BaseTest {
    public void testBaseWadlGenerator() throws Exception {
        AbstractResourceDescriptorImpl ard = new AbstractResourceDescriptorImpl(Resource1.class);
        WadlProcessor wadlProcessor = new WadlProcessor();
        Application app = wadlProcessor.process((AbstractResourceDescriptor)ard, new URI("http://localhost:8080/ws/rs"));
        JAXBContext jctx = JAXBContext.newInstance((Class[])new Class[]{Application.class});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        jctx.createMarshaller().marshal((Object)app, (OutputStream)bout);
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(true);
        Document doc = f.newDocumentBuilder().parse(new ByteArrayInputStream(bout.toByteArray()));
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext(new DummyNamespaceContext());
        String str = (String)xp.evaluate("count(//wadl:resource)", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"4", (String)str);
        str = (String)xp.evaluate("count(//wadl:resource[@path='a/{b}'])", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"1", (String)str);
        str = (String)xp.evaluate("count(//wadl:resource[@path='{c}/{d}'])", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"1", (String)str);
        str = (String)xp.evaluate("count(//wadl:resource[@path='{c}/{d}/{e}'])", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"1", (String)str);
        str = (String)xp.evaluate("count(//wadl:resource[@path='sub/{x}'])", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"1", (String)str);
        str = (String)xp.evaluate("count(//wadl:resource[@path='a/{b}']/wadl:method)", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"5", (String)str);
        NodeList nl = (NodeList)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:method[@id='m1']/@name", doc, XPathConstants.NODESET);
        WadlProcessorTest.assertEquals((int)1, (int)nl.getLength());
        boolean get = false;
        for (int i = 0; i < nl.getLength(); ++i) {
            String t = nl.item(i).getNodeValue();
            if (!t.equals("GET")) continue;
            get = true;
        }
        WadlProcessorTest.assertTrue((boolean)get);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:method[@id='m2']/@name", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"POST", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:method[@id='m2']/wadl:request/wadl:param[@style='header']/@name", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"content-type", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:method[@id='m3']/@name", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"DELETE", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:method[@id='m4']/@name", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"PUT", (String)str);
        nl = (NodeList)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}']/wadl:method/@name", doc, XPathConstants.NODESET);
        WadlProcessorTest.assertEquals((int)1, (int)nl.getLength());
        boolean subget = false;
        for (int i = 0; i < nl.getLength(); ++i) {
            String t = nl.item(i).getNodeValue();
            if (!t.equals("GET")) continue;
            subget = true;
        }
        WadlProcessorTest.assertTrue((boolean)subget);
        str = (String)xp.evaluate("count(//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}/{e}']/wadl:method)", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"1", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}']/wadl:param[@name='c']/@style", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"template", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}']/wadl:param[@name='b']/@style", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"template", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}/{e}']/wadl:param[@name='c']/@style", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"template", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}/{e}']/wadl:param[@name='e']/@style", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"template", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='{c}/{d}/{e}']/wadl:method[@id='m6']/@name", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"POST", (String)str);
        nl = (NodeList)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='sub/{x}']/wadl:method/@name", doc, XPathConstants.NODESET);
        WadlProcessorTest.assertEquals((int)2, (int)nl.getLength());
        boolean childget = false;
        boolean childopt = false;
        for (int i = 0; i < nl.getLength(); ++i) {
            String t = nl.item(i).getNodeValue();
            if (t.equals("GET")) {
                childget = true;
            }
            if (!t.equals("OPTIONS")) continue;
            childopt = true;
        }
        WadlProcessorTest.assertTrue((childget && childopt ? 1 : 0) != 0);
        str = (String)xp.evaluate("count(//wadl:resource[@path='a/{b}']/wadl:resource[@path='sub/{x}']/wadl:method)", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"2", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='sub/{x}']/wadl:param[@name='x']/@style", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"template", (String)str);
        str = (String)xp.evaluate("//wadl:resource[@path='a/{b}']/wadl:resource[@path='sub/{x}']/wadl:method[@id='m0']/wadl:response/wadl:representation/@mediaType", doc, XPathConstants.STRING);
        WadlProcessorTest.assertEquals((String)"text/plain", (String)str);
    }

    @Path(value="a/{b}")
    public static class Resource1 {
        @GET
        public String m1(@Context UriInfo uriInfo) {
            return uriInfo.getAbsolutePath().toString();
        }

        @POST
        @Consumes(value={"text/plain"})
        @Produces(value={"text/plain"})
        public String m2(@HeaderParam(value="content-type") String contentType, String data) {
            return data;
        }

        @DELETE
        public void m3(@DefaultValue(value="1") @MatrixParam(value="id") int j) {
        }

        @PUT
        @Consumes(value={"text/xml"})
        public void m4(DOMSource ds) {
        }

        @GET
        @Path(value="{c}/{d}")
        public String m5(@PathParam(value="b") String b, @PathParam(value="c") String a) {
            return b;
        }

        @POST
        @Path(value="{c}/{d}/{e}")
        public void m6(@PathParam(value="c") String b, @PathParam(value="e") String a) {
        }

        @Path(value="sub/{x}")
        public Resource2 m7() {
            return new Resource2Impl();
        }
    }

    private static class DummyNamespaceContext
    implements NamespaceContext {
        private final String nsPrefix;
        private final String nsUri;
        private final Iterator nsIter;

        public DummyNamespaceContext() {
            this.nsPrefix = "wadl";
            this.nsUri = "http://research.sun.com/wadl/2006/10";
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(this.nsPrefix);
            this.nsIter = l.iterator();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals(this.nsPrefix)) {
                return this.nsUri;
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI.equals(this.nsUri)) {
                return this.nsPrefix;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            if (namespaceURI.equals(this.nsUri)) {
                return this.nsIter;
            }
            return Collections.emptyList().iterator();
        }
    }

    public static class Resource2Impl
    implements Resource2 {
        @Override
        public String m0(@PathParam(value="x") String x) {
            return x;
        }
    }

    public static interface Resource2 {
        @GET
        @Produces(value={"text/plain"})
        public String m0(@PathParam(value="x") String var1);
    }
}

