/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class MediaTypeTest
extends BaseTest {
    public void testProducedMediaTypes() throws Exception {
        Resource1 resource1 = new Resource1();
        Resource2 resource2 = new Resource2();
        this.registry(resource1);
        this.registry(resource2);
        MediaTypeTest.assertEquals((int)200, (int)this.launcher.service("GET", "/a", "", null, null, null).getStatus());
        MediaTypeTest.assertEquals((Object)"m0", (Object)this.launcher.service("GET", "/a", "", null, null, null).getEntity());
        MediaTypeTest.assertEquals((Object)MediaType.WILDCARD_TYPE, (Object)this.launcher.service("GET", "/a", "", null, null, null).getContentType());
        MediaTypeTest.assertEquals((int)200, (int)this.launcher.service("GET", "/b/c", "", null, null, null).getStatus());
        MediaTypeTest.assertEquals((Object)MediaType.TEXT_PLAIN_TYPE, (Object)this.launcher.service("GET", "/b/c", "", null, null, null).getContentType());
        MediaTypeTest.assertEquals((int)200, (int)this.launcher.service("GET", "/b/d", "", null, null, null).getStatus());
        MediaTypeTest.assertEquals((Object)MediaType.TEXT_XML_TYPE, (Object)this.launcher.service("GET", "/b/d", "", null, null, null).getContentType());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Accept", (Object)"application/json");
        MediaTypeTest.assertEquals((int)406, (int)this.launcher.service("GET", "/b/d", "", (Map)headers, null, null).getStatus());
        MediaTypeTest.assertEquals((Object)MediaType.TEXT_XML_TYPE, (Object)this.launcher.service("GET", "/b/d", "", null, null, null).getContentType());
        this.unregistry(resource1);
        this.unregistry(resource2);
    }

    public void testConsumedMediaTypes() throws Exception {
        Resource4 resource4 = new Resource4();
        this.registry(resource4);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        MediaTypeTest.assertEquals((int)200, (int)this.launcher.service("GET", "/d/e", "", (Map)headers, null, null).getStatus());
        MediaTypeTest.assertEquals((Object)"m0", (Object)this.launcher.service("GET", "/d/e", "", (Map)headers, null, null).getEntity());
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"application/json");
        MediaTypeTest.assertEquals((int)200, (int)this.launcher.service("GET", "/d/f", "", (Map)headers, null, null).getStatus());
        MediaTypeTest.assertEquals((Object)"m1", (Object)this.launcher.service("GET", "/d/f", "", (Map)headers, null, null).getEntity());
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/html");
        MediaTypeTest.assertEquals((int)415, (int)this.launcher.service("GET", "/d/f", "", (Map)headers, null, null).getStatus());
        this.unregistry(resource4);
    }

    @Path(value="/a")
    public static class Resource1 {
        @GET
        public String m0() {
            return "m0";
        }
    }

    @Path(value="/b")
    @Produces(value={"text/plain"})
    public static class Resource2 {
        @GET
        @Path(value="/c")
        public String m0() {
            return "m0";
        }

        @GET
        @Path(value="/d")
        @Produces(value={"text/xml"})
        public String m1() {
            return "m0";
        }

        @GET
        @Path(value="/e")
        @Produces(value={"text/xml"})
        public String m2() {
            return "m0";
        }
    }

    @Path(value="/d")
    @Consumes(value={"text/plain"})
    public static class Resource4 {
        @GET
        @Path(value="/e")
        public String m0(@HeaderParam(value="Content-Type") String type) {
            TestCase.assertEquals((String)"text/plain", (String)type);
            return "m0";
        }

        @GET
        @Path(value="/f")
        @Consumes(value={"application/json"})
        public String m1(@HeaderParam(value="Content-Type") String type) {
            TestCase.assertEquals((String)"application/json", (String)type);
            return "m1";
        }
    }
}

