/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.uri;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.exoplatform.services.rest.uri.UriPattern;

public class UriPatternTest
extends TestCase {
    private boolean log = false;

    public void testUriComparator() {
        String[] as;
        ArrayList<UriPattern> l = new ArrayList<UriPattern>();
        for (String a : as = new String[]{"/a", "a/b/c/d/{e}", "a/b/{c}/d/{e}", "a/{b}", "a/b/c/d/e"}) {
            l.add(new UriPattern(a));
        }
        Collections.sort(l, UriPattern.URIPATTERN_COMPARATOR);
        UriPatternTest.assertEquals((String)"/a/b/c/d/e", (String)((UriPattern)l.get(0)).getTemplate());
        UriPatternTest.assertEquals((String)"/a/b/c/d/{e}", (String)((UriPattern)l.get(1)).getTemplate());
        UriPatternTest.assertEquals((String)"/a/b/{c}/d/{e}", (String)((UriPattern)l.get(2)).getTemplate());
        UriPatternTest.assertEquals((String)"/a/{b}", (String)((UriPattern)l.get(3)).getTemplate());
        UriPatternTest.assertEquals((String)"/a", (String)((UriPattern)l.get(4)).getTemplate());
    }

    public void testRegex() {
        UriPattern p = new UriPattern("/");
        UriPatternTest.assertEquals((String)"(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a");
        UriPatternTest.assertEquals((String)"/a(/.*)?", (String)p.getRegex());
        p = new UriPattern("a");
        UriPatternTest.assertEquals((String)"/a(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a/");
        UriPatternTest.assertEquals((String)"/a(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a/{x}");
        UriPatternTest.assertEquals((String)"/a/([^/]+?)(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a/{x}/");
        UriPatternTest.assertEquals((String)"/a/([^/]+?)(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a/{x:}/");
        UriPatternTest.assertEquals((String)"/a/([^/]+?)(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a/{x  :   .*}/");
        UriPatternTest.assertEquals((String)"/a/(.*)(/.*)?", (String)p.getRegex());
        p = new UriPattern("/a/{x  :   .*}/");
        UriPatternTest.assertEquals((String)"/a/(.*)(/.*)?", (String)p.getRegex());
    }

    public void testMatch() {
        this.testMatch("/", "/a/b", new String[]{"/a/b"});
        this.testMatch("/", "/a/b/", new String[]{"/a/b/"});
        this.testMatch("/a", "/a/b", new String[]{"/b"});
        this.testMatch("a", "/a/b", new String[]{"/b"});
        this.testMatch("/a/{x}", "/a/b", new String[]{"b", null});
        this.testMatch("/a/{x}", "/a/b/", new String[]{"b", "/"});
        this.testMatch("/a/{x:.*}", "/a/b/", new String[]{"b/", null});
        this.testMatch("/a/{x:.*}", "/a/b", new String[]{"b", null});
        this.testMatch("/a/{x:.*}", "/a/b/c/d/e", new String[]{"b/c/d/e", null});
        this.testMatch("/a/{x:.*}", "/a/b/c/d/e/", new String[]{"b/c/d/e/", null});
        this.testMatch("/a{x:.*}", "/a/b/c/d/e", new String[]{"/b/c/d/e", null});
        this.testMatch("/a{x:.*}", "/a/b/c/d/e/", new String[]{"/b/c/d/e/", null});
        this.testMatch("/a/{x}{y:.*}", "/a/b/c/d/e", new String[]{"b", "/c/d/e", null});
        this.testMatch("/a/{x}/{y:.*}", "/a/b/c/d/e", new String[]{"b", "c/d/e", null});
        this.testMatch("/a/{x}/{y:.*}/{z}", "/a/b/c/d/e", new String[]{"b", "c/d", "e", null});
        this.testMatch("/{a}/{b}/{c}/{x:.*}/{e}/{f}/{g}/", "/a/b/c/1/2/3/4/5/e/f/g/", new String[]{"a", "b", "c", "1/2/3/4/5", "e", "f", "g", "/"});
        this.testMatch("/{a}/{b}/{c}/{x:.*}/{e}/{f}/{g}/", "/a/b/c/1/2/3/4/5/e/f/g", new String[]{"a", "b", "c", "1/2/3/4/5", "e", "f", "g", null});
        this.testMatch("/a /{x}{y:(/)?}", "/a%20/b/", new String[]{"b", "/", null});
        this.testMatch("/a/{x}{y:(/)?}", "/a/b", new String[]{"b", "", null});
        this.testMatch("/{x:\\d+}.{y:\\d+}", "/111.222", new String[]{"111", "222", null});
        this.testMatch("/{x:\\d+}.{y:\\d+}", "/111.222/", new String[]{"111", "222", "/"});
        this.testMatch("/a/b/{x}{y:(/)?}", "/a/b/c", new String[]{"c", "", null});
        this.testMatch("/a/b/{x}{y:(/)?}", "/a/b/c/", new String[]{"c", "/", null});
        this.testMatch("/a/b/{x}/{y}/{z}/{X:.*}", "/a/b/c/d/e/f/g/h", new String[]{"c", "d", "e", "f/g/h", null});
        this.testMatch("/a/b/{x}/{y}/{z}/{X:.*}", "/a/b/c/d/e/f/g/h/", new String[]{"c", "d", "e", "f/g/h/", null});
        this.testMatch("/a/b/{x}/{y}/{z}/{X:.*}{Y:[/]+?}", "/a/b/c/d/e/f/g/h/", new String[]{"c", "d", "e", "f/g/h", "/", null});
        this.testMatch("/a/b/{x}/{y}/{z}/{X:.*}{Y:/+?}", "/a/b/c/d/e/f/g/h/", new String[]{"c", "d", "e", "f/g/h", "/", null});
        this.testMatch("/a/b/{x}/{X:.*}/{y}/{z}", "/a/b/c/d/e/f/g/h", new String[]{"c", "d/e/f", "g", "h", null});
        this.testMatch("/a/b/{x}/{X:.*}/{y}", "/a/b/c/d/e/f/g/h", new String[]{"c", "d/e/f/g", "h", null});
        this.testMatch("/a/b/{x}/{X:.*}/{y}", "/a/b/c/d/e/f/g/h/", new String[]{"c", "d/e/f/g", "h", "/"});
    }

    private void testMatch(String pattern, String uri, String[] values) {
        UriPattern p = new UriPattern(pattern);
        if (this.log) {
            System.out.println("URI:        " + uri);
            System.out.println("REGEX:      " + p.getRegex());
            System.out.println("PATTERN:    " + pattern);
            System.out.println("TEMPLATE:   " + p.getTemplate());
        }
        ArrayList l = new ArrayList();
        UriPatternTest.assertTrue((boolean)p.match(uri, l));
        if (this.log) {
            System.out.println("PARAMETERS: " + String.valueOf(p.getParameterNames()));
            System.out.println("VARIABLES:  " + String.valueOf(l));
            System.out.println();
        }
        UriPatternTest.assertEquals((int)values.length, (int)l.size());
        int i = 0;
        for (String t : l) {
            UriPatternTest.assertEquals((String)values[i++], (String)t);
        }
    }
}

