/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.List;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.AcceptLanguage;
import org.exoplatform.services.rest.impl.header.AcceptLanguageHeaderDelegate;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

public class AcceptLanguageTest
extends BaseTest {
    public void testValueOf() {
        String al = "en-gb;q=0.8";
        AcceptLanguage acceptedLanguage = AcceptLanguage.valueOf((String)al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"gb", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
        al = "en;q=0.8";
        acceptedLanguage = AcceptLanguage.valueOf((String)al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
        al = "en";
        acceptedLanguage = AcceptLanguage.valueOf((String)al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
        al = "en-GB";
        acceptedLanguage = AcceptLanguage.valueOf((String)al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"gb", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
    }

    public void testFromString() {
        AcceptLanguageHeaderDelegate hd = new AcceptLanguageHeaderDelegate();
        String al = "en-gb;q=0.8";
        AcceptLanguage acceptedLanguage = hd.fromString(al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"gb", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
        al = "en;q=0.8";
        acceptedLanguage = hd.fromString(al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
        al = "en";
        acceptedLanguage = hd.fromString(al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
        al = "en-GB";
        acceptedLanguage = hd.fromString(al);
        AcceptLanguageTest.assertEquals((String)"en", (String)acceptedLanguage.getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"gb", (String)acceptedLanguage.getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(acceptedLanguage.getQvalue()));
    }

    public void testListProducer() {
        List l = HeaderHelper.createAcceptedLanguageList(null);
        AcceptLanguageTest.assertEquals((int)1, (int)l.size());
        l = HeaderHelper.createAcceptedLanguageList((String)"");
        AcceptLanguageTest.assertEquals((int)1, (int)l.size());
        String ln = "da;q=0.825,   en-GB,  en;q=0.8";
        l = HeaderHelper.createAcceptedLanguageList((String)ln);
        AcceptLanguageTest.assertEquals((int)3, (int)l.size());
        AcceptLanguageTest.assertEquals((String)"en", (String)((AcceptLanguage)l.get(0)).getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"gb", (String)((AcceptLanguage)l.get(0)).getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(((AcceptLanguage)l.get(0)).getQvalue()));
        AcceptLanguageTest.assertEquals((String)"da", (String)((AcceptLanguage)l.get(1)).getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"", (String)((AcceptLanguage)l.get(1)).getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(0.825f), (Object)Float.valueOf(((AcceptLanguage)l.get(1)).getQvalue()));
        AcceptLanguageTest.assertEquals((String)"en", (String)((AcceptLanguage)l.get(2)).getPrimaryTag());
        AcceptLanguageTest.assertEquals((String)"", (String)((AcceptLanguage)l.get(2)).getSubTag());
        AcceptLanguageTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(((AcceptLanguage)l.get(2)).getQvalue()));
    }
}

