/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class ExceptionMapperTest
extends BaseTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.providers.addExceptionMapper(ExceptionMapper1.class);
        this.providers.addExceptionMapper(ExceptionMapper2.class);
        this.providers.addExceptionMapper(ExceptionMapper3.class);
        this.providers.addExceptionMapper(ExceptionMapper4.class);
    }

    public void testExceptionMappers() throws Exception {
        this.registry(Resource1.class);
        ContainerResponse resp = this.launcher.service("GET", "/a/1", "", null, null, null);
        ExceptionMapperTest.assertEquals((int)200, (int)resp.getStatus());
        ExceptionMapperTest.assertEquals((Object)"IllegalArgumentException", (Object)resp.getEntity());
        resp = this.launcher.service("GET", "/a/2", "", null, null, null);
        ExceptionMapperTest.assertEquals((int)200, (int)resp.getStatus());
        ExceptionMapperTest.assertEquals((Object)"RuntimeException", (Object)resp.getEntity());
        resp = this.launcher.service("GET", "/a/3", "", null, null, null);
        ExceptionMapperTest.assertEquals((int)200, (int)resp.getStatus());
        ExceptionMapperTest.assertEquals((Object)"WebApplicationException", (Object)resp.getEntity());
        resp = this.launcher.service("GET", "/a/4", "", null, null, null);
        ExceptionMapperTest.assertEquals((int)500, (int)resp.getStatus());
        ExceptionMapperTest.assertEquals((Object)"this exception must not be hidden by any ExceptionMapper", (Object)resp.getEntity());
        resp = this.launcher.service("GET", "/a/5", "", null, null, null);
        ExceptionMapperTest.assertEquals((int)200, (int)resp.getStatus());
        ExceptionMapperTest.assertEquals((Object)"MockException", (Object)resp.getEntity());
        this.unregistry(Resource1.class);
    }

    public static class ExceptionMapper1
    implements ExceptionMapper<IllegalArgumentException> {
        public Response toResponse(IllegalArgumentException exception) {
            return Response.status((int)200).entity((Object)"IllegalArgumentException").build();
        }
    }

    public static class ExceptionMapper2
    implements ExceptionMapper<RuntimeException> {
        public Response toResponse(RuntimeException exception) {
            return Response.status((int)200).entity((Object)"RuntimeException").build();
        }
    }

    public static class ExceptionMapper3
    implements ExceptionMapper<WebApplicationException> {
        public Response toResponse(WebApplicationException exception) {
            return Response.status((int)200).entity((Object)"WebApplicationException").build();
        }
    }

    public static class ExceptionMapper4
    implements ExceptionMapper<MockException> {
        public Response toResponse(MockException exception) {
            return Response.status((int)200).entity((Object)"MockException").build();
        }
    }

    @Path(value="a")
    public static class Resource1 {
        @GET
        @Path(value="1")
        public void m1() {
            throw new IllegalArgumentException();
        }

        @GET
        @Path(value="2")
        public void m2() {
            throw new RuntimeException();
        }

        @GET
        @Path(value="3")
        public void m3() {
            throw new WebApplicationException(Response.status((int)400).build());
        }

        @GET
        @Path(value="4")
        public void m4() {
            throw new WebApplicationException(Response.status((int)500).entity((Object)"this exception must not be hidden by any ExceptionMapper").build());
        }

        @GET
        @Path(value="5")
        public void m5() throws MockException {
            throw new MockException();
        }
    }

    public static class MockException
    extends Exception {
        private static final long serialVersionUID = 5029726201933185270L;
    }
}

