/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SourceEntityProviderTest
extends BaseTest {
    private byte[] data;
    private MediaType mediaType;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mediaType = new MediaType("application", "xml");
        this.data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><message>to be or not to be</message></root>".getBytes("UTF-8");
    }

    public void testReadStreamSourceEntityProvider() throws Exception {
        MessageBodyReader reader = this.providers.getMessageBodyReader(StreamSource.class, null, null, this.mediaType);
        SourceEntityProviderTest.assertNotNull((Object)reader);
        SourceEntityProviderTest.assertTrue((boolean)reader.isReadable(StreamSource.class, StreamSource.class, null, this.mediaType));
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Content-Length", (Object)("" + this.data.length));
        StreamSource src = (StreamSource)reader.readFrom(StreamSource.class, StreamSource.class, null, this.mediaType, (MultivaluedMap)h, (InputStream)new ByteArrayInputStream(this.data));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory.newInstance().newTransformer().transform(src, new StreamResult(out));
        SourceEntityProviderTest.write(out);
    }

    public void testWriteStreamSourceEntityProvider() throws Exception {
        StreamSource src = new StreamSource(new ByteArrayInputStream(this.data));
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(StreamSource.class, null, null, this.mediaType);
        SourceEntityProviderTest.assertNotNull((Object)writer);
        SourceEntityProviderTest.assertTrue((boolean)writer.isWriteable(StreamSource.class, StreamSource.class, null, this.mediaType));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTo((Object)src, StreamSource.class, StreamSource.class, null, this.mediaType, null, (OutputStream)out);
        SourceEntityProviderTest.write(out);
    }

    public void testReadSAXSourceEntityProvider() throws Exception {
        MessageBodyReader reader = this.providers.getMessageBodyReader(SAXSource.class, null, null, this.mediaType);
        SourceEntityProviderTest.assertNotNull((Object)reader);
        SourceEntityProviderTest.assertTrue((boolean)reader.isReadable(SAXSource.class, SAXSource.class, null, this.mediaType));
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Content-Length", (Object)("" + this.data.length));
        SAXSource src = (SAXSource)reader.readFrom(SAXSource.class, SAXSource.class, null, this.mediaType, (MultivaluedMap)h, (InputStream)new ByteArrayInputStream(this.data));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory.newInstance().newTransformer().transform(src, new StreamResult(out));
        SourceEntityProviderTest.write(out);
    }

    public void testWriteSAXSourceEntityProvider() throws Exception {
        SAXSource src = new SAXSource(new InputSource(new ByteArrayInputStream(this.data)));
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(SAXSource.class, null, null, this.mediaType);
        SourceEntityProviderTest.assertNotNull((Object)writer);
        SourceEntityProviderTest.assertTrue((boolean)writer.isWriteable(SAXSource.class, SAXSource.class, null, this.mediaType));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTo((Object)src, SAXSource.class, SAXSource.class, null, this.mediaType, null, (OutputStream)out);
        SourceEntityProviderTest.write(out);
    }

    public void testReadDOMSourceEntityProvider() throws Exception {
        MessageBodyReader reader = this.providers.getMessageBodyReader(DOMSource.class, null, null, this.mediaType);
        SourceEntityProviderTest.assertNotNull((Object)reader);
        SourceEntityProviderTest.assertTrue((boolean)reader.isReadable(DOMSource.class, DOMSource.class, null, this.mediaType));
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Content-Length", (Object)("" + this.data.length));
        DOMSource src = (DOMSource)reader.readFrom(DOMSource.class, DOMSource.class, null, this.mediaType, (MultivaluedMap)h, (InputStream)new ByteArrayInputStream(this.data));
        Node root = src.getNode().getFirstChild();
        SourceEntityProviderTest.assertEquals((String)"root", (String)root.getNodeName());
        Node message = root.getFirstChild();
        SourceEntityProviderTest.assertEquals((String)"message", (String)message.getNodeName());
        SourceEntityProviderTest.assertEquals((String)"to be or not to be", (String)message.getFirstChild().getNodeValue());
    }

    public void testWriteDOMSourceEntityProvider() throws Exception {
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(this.data));
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(DOMSource.class, null, null, this.mediaType);
        SourceEntityProviderTest.assertNotNull((Object)writer);
        SourceEntityProviderTest.assertTrue((boolean)writer.isWriteable(DOMSource.class, DOMSource.class, null, this.mediaType));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.writeTo((Object)new DOMSource(d), DOMSource.class, DOMSource.class, null, this.mediaType, null, (OutputStream)out);
        SourceEntityProviderTest.write(out);
    }

    private static void write(ByteArrayOutputStream out) throws Exception {
    }
}

