/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.push;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PushMeterRegistry
extends MeterRegistry {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PushMeterRegistry.class);
    private static final double PERCENT_RANGE_OF_RANDOM_PUBLISHING_OFFSET = 0.8;
    private final PushRegistryConfig config;
    private final AtomicBoolean publishing = new AtomicBoolean(false);
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;

    protected PushMeterRegistry(PushRegistryConfig config, Clock clock) {
        super(clock);
        config.requireValid();
        this.config = config;
    }

    protected abstract void publish();

    void publishSafely() {
        if (this.publishing.compareAndSet(false, true)) {
            try {
                this.publish();
            }
            catch (Throwable e) {
                logger.warn("Unexpected exception thrown while publishing metrics for " + this.getClass().getSimpleName(), e);
            }
            finally {
                this.publishing.set(false);
            }
        } else {
            logger.warn("Publishing is already in progress. Skipping duplicate call to publish().");
        }
    }

    protected boolean isPublishing() {
        return this.publishing.get();
    }

    @Deprecated
    public final void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void start(ThreadFactory threadFactory) {
        if (this.scheduledExecutorService != null) {
            this.stop();
        }
        if (this.config.enabled()) {
            logger.info("publishing metrics for " + this.getClass().getSimpleName() + " every " + TimeUtils.format(this.config.step()));
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            long stepMillis = this.config.step().toMillis();
            long initialDelayMillis = this.calculateInitialDelay();
            this.scheduledExecutorService.scheduleAtFixedRate(this::publishSafely, initialDelayMillis, stepMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void close() {
        this.stop();
        if (this.config.enabled() && !this.isClosed()) {
            this.publishSafely();
        }
        super.close();
    }

    long calculateInitialDelay() {
        long stepMillis = this.config.step().toMillis();
        Random random = new Random();
        long randomOffsetWithinStep = Math.max(0L, (long)((double)stepMillis * random.nextDouble() * 0.8) - 2L);
        long offsetToStartOfNextStep = stepMillis - this.clock.wallTime() % stepMillis;
        return offsetToStartOfNextStep + 2L + randomOffsetWithinStep;
    }
}

