/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.dynatrace.AbstractDynatraceExporter;
import io.micrometer.dynatrace.DynatraceApiVersion;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.types.DynatraceDistributionSummary;
import io.micrometer.dynatrace.types.DynatraceLongTaskTimer;
import io.micrometer.dynatrace.types.DynatraceTimer;
import io.micrometer.dynatrace.v1.DynatraceExporterV1;
import io.micrometer.dynatrace.v2.DynatraceExporterV2;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DynatraceMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("dynatrace-metrics-publisher");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DynatraceMeterRegistry.class);
    private final boolean useDynatraceSummaryInstruments;
    private final boolean shouldAddZeroPercentile;
    private final DenyZeroPercentileMeterFilter zeroPercentileMeterFilter = new DenyZeroPercentileMeterFilter();
    private final AbstractDynatraceExporter exporter;

    public DynatraceMeterRegistry(DynatraceConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private DynatraceMeterRegistry(DynatraceConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.useDynatraceSummaryInstruments = config.useDynatraceSummaryInstruments();
        boolean bl = this.shouldAddZeroPercentile = config.apiVersion() == DynatraceApiVersion.V2 && !this.useDynatraceSummaryInstruments;
        if (config.apiVersion() == DynatraceApiVersion.V2) {
            logger.info("Exporting to Dynatrace metrics API v2");
            this.exporter = new DynatraceExporterV2(config, clock, httpClient);
        } else {
            logger.info("Exporting to Dynatrace metrics API v1");
            this.exporter = new DynatraceExporterV1(config, clock, httpClient);
        }
        if (this.shouldAddZeroPercentile) {
            this.config().meterFilter((MeterFilter)this.zeroPercentileMeterFilter);
        }
        this.start(threadFactory);
    }

    public static Builder builder(DynatraceConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        this.exporter.export(this.getMeters());
    }

    protected TimeUnit getBaseTimeUnit() {
        return this.exporter.getBaseTimeUnit();
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        if (this.useDynatraceSummaryInstruments) {
            return new DynatraceDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
        }
        DistributionStatisticConfig config = distributionStatisticConfig;
        if (this.shouldAddZeroPercentile) {
            config = this.addZeroPercentileIfMissing(id, distributionStatisticConfig);
        }
        return super.newDistributionSummary(id, config, scale);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        if (this.useDynatraceSummaryInstruments) {
            return new DynatraceTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.exporter.getBaseTimeUnit());
        }
        DistributionStatisticConfig config = distributionStatisticConfig;
        if (this.shouldAddZeroPercentile) {
            config = this.addZeroPercentileIfMissing(id, distributionStatisticConfig);
        }
        return super.newTimer(id, config, pauseDetector);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        if (this.useDynatraceSummaryInstruments) {
            return new DynatraceLongTaskTimer(id, this.clock, this.exporter.getBaseTimeUnit(), distributionStatisticConfig, false);
        }
        DistributionStatisticConfig config = distributionStatisticConfig;
        if (this.shouldAddZeroPercentile) {
            config = this.addZeroPercentileIfMissing(id, distributionStatisticConfig);
        }
        return super.newLongTaskTimer(id, config);
    }

    private boolean containsZero(double[] percentiles) {
        return Arrays.stream(percentiles).anyMatch(percentile -> percentile == 0.0);
    }

    private DistributionStatisticConfig addZeroPercentileIfMissing(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        double[] percentiles;
        double[] configPercentiles = distributionStatisticConfig.getPercentiles();
        if (configPercentiles == null) {
            percentiles = new double[]{0.0};
            this.zeroPercentileMeterFilter.addMeterId(id);
        } else if (!this.containsZero(configPercentiles)) {
            percentiles = new double[configPercentiles.length + 1];
            System.arraycopy(configPercentiles, 0, percentiles, 0, configPercentiles.length);
            percentiles[configPercentiles.length] = 0.0;
            this.zeroPercentileMeterFilter.addMeterId(id);
        } else {
            return distributionStatisticConfig;
        }
        return DistributionStatisticConfig.builder().percentiles(percentiles).build().merge(distributionStatisticConfig);
    }

    static /* synthetic */ ThreadFactory access$100() {
        return DEFAULT_THREAD_FACTORY;
    }

    private static class DenyZeroPercentileMeterFilter
    implements MeterFilter {
        private final Set<String> metersWithArtificialZeroPercentile = ConcurrentHashMap.newKeySet();

        private DenyZeroPercentileMeterFilter() {
        }

        private boolean hasArtificialZeroPercentile(Meter.Id id) {
            return this.metersWithArtificialZeroPercentile.contains(id.getName()) && "0".equals(id.getTag("phi"));
        }

        public MeterFilterReply accept(Meter.Id id) {
            return this.hasArtificialZeroPercentile(id) ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
        }

        public void addMeterId(Meter.Id id) {
            this.metersWithArtificialZeroPercentile.add(id.getName() + ".percentile");
        }
    }

    public static class Builder {
        private final DynatraceConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = DynatraceMeterRegistry.access$100();
        private HttpSender httpClient;

        Builder(DynatraceConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DynatraceMeterRegistry build() {
            return new DynatraceMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

