/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.ssl.SniCompletionEvent;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.reactor.netty.channel.AbstractChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;

public class ChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ChannelMetricsRecorder recorder;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder(), this.proxyAddress);
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder, this.remoteAddress, this.proxyAddress);
    }

    @Override
    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static class TlsMetricsHandler
    extends ChannelInboundHandlerAdapter {
        protected final SocketAddress proxyAddress;
        protected final ChannelMetricsRecorder recorder;
        protected final SocketAddress remoteAddress;
        boolean listenerAdded;

        TlsMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress) {
            this.proxyAddress = proxyAddress;
            this.recorder = recorder;
            this.remoteAddress = remoteAddress;
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            this.addListener(ctx);
            ctx.fireChannelActive();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SniCompletionEvent) {
                this.addListener(ctx);
            }
            ctx.fireUserEventTriggered(evt);
        }

        protected void recordTlsHandshakeTime(ChannelHandlerContext ctx, long tlsHandshakeTimeStart, String status) {
            if (this.proxyAddress == null) {
                this.recorder.recordTlsHandshakeTime(this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
            } else {
                this.recorder.recordTlsHandshakeTime(this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress(), this.proxyAddress, Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
            }
        }

        private void addListener(ChannelHandlerContext ctx) {
            SslHandler sslHandler;
            if (!this.listenerAdded && (sslHandler = ctx.pipeline().get(SslHandler.class)) != null) {
                this.listenerAdded = true;
                long tlsHandshakeTimeStart = System.nanoTime();
                sslHandler.handshakeFuture().addListener((? extends Future<? super V> f) -> {
                    ctx.pipeline().remove(this);
                    this.recordTlsHandshakeTime(ctx, tlsHandshakeTimeStart, f.isSuccess() ? "SUCCESS" : "ERROR");
                });
            }
        }
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final SocketAddress proxyAddress;
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress proxyAddress) {
            this.proxyAddress = proxyAddress;
            this.recorder = recorder;
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener(future -> {
                ctx.pipeline().remove(this);
                if (this.proxyAddress == null) {
                    this.recorder.recordConnectTime(remoteAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), future.isSuccess() ? "SUCCESS" : "ERROR");
                } else {
                    this.recorder.recordConnectTime(remoteAddress, this.proxyAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), future.isSuccess() ? "SUCCESS" : "ERROR");
                }
            });
        }
    }
}

