/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.Span;
import brave.Tracing;
import brave.baggage.BaggageField;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageInScope;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BraveBaggageManager
implements Closeable,
BaggageManager {
    private final List<String> tagFields;

    public BraveBaggageManager(List<String> tagFields) {
        this.tagFields = tagFields;
    }

    public BraveBaggageManager() {
        this.tagFields = Collections.emptyList();
    }

    public Map<String, String> getAllBaggage() {
        return BaggageField.getAllValues();
    }

    public Map<String, String> getAllBaggage(TraceContext traceContext) {
        if (traceContext == null) {
            return this.getAllBaggage();
        }
        return BaggageField.getAllValues((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext));
    }

    public Baggage getBaggage(String name) {
        return this.createBaggage(name);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        BaggageField baggageField = BaggageField.getByName((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext), (String)name);
        if (baggageField == null) {
            return null;
        }
        Span span = BraveBaggageManager.currentSpan();
        return new BraveBaggageInScope(baggageField, BraveTraceContext.toBrave(traceContext), span, this.tagFields);
    }

    @Deprecated
    public Baggage createBaggage(String name) {
        return this.baggage(name);
    }

    private BraveBaggageInScope baggage(String name, TraceContext traceContext) {
        Span span = BraveBaggageManager.currentSpan();
        return new BraveBaggageInScope(BaggageField.create((String)name), BraveTraceContext.toBrave(traceContext), span, this.tagFields);
    }

    private BraveBaggageInScope baggage(String name) {
        Span span = BraveBaggageManager.currentSpan();
        return new BraveBaggageInScope(BaggageField.create((String)name), span != null ? span.context() : null, span, this.tagFields);
    }

    private static Span currentSpan() {
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.tracer().currentSpan() : null;
    }

    @Deprecated
    public Baggage createBaggage(String name, String value) {
        return this.baggage(name).set(value);
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.baggage(name).makeCurrent(value);
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.baggage(name, traceContext).makeCurrent(traceContext, value);
    }

    @Override
    public void close() {
    }
}

