/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.otel.bridge.EventListener;
import io.micrometer.tracing.otel.bridge.EventPublishingContextWrapper;
import io.opentelemetry.api.trace.Span;
import org.slf4j.MDC;

public class Slf4JEventListener
implements EventListener {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(Slf4JEventListener.class);
    private static final String DEFAULT_TRACE_ID_KEY = "traceId";
    private static final String DEFAULT_SPAN_ID_KEY = "spanId";
    private final String traceIdKey;
    private final String spanIdKey;

    public Slf4JEventListener() {
        this(DEFAULT_TRACE_ID_KEY, DEFAULT_SPAN_ID_KEY);
    }

    public Slf4JEventListener(String traceIdKey, String spanIdKey) {
        this.traceIdKey = traceIdKey;
        this.spanIdKey = spanIdKey;
    }

    private void onScopeAttached(EventPublishingContextWrapper.ScopeAttachedEvent event) {
        log.trace("Got scope changed event [{}]", (Object)event);
        Span span = event.getSpan();
        if (span != null) {
            MDC.put((String)this.traceIdKey, (String)span.getSpanContext().getTraceId());
            MDC.put((String)this.spanIdKey, (String)span.getSpanContext().getSpanId());
        }
    }

    private void onScopeRestored(EventPublishingContextWrapper.ScopeRestoredEvent event) {
        log.trace("Got scope restored event [{}]", (Object)event);
        Span span = event.getSpan();
        if (span != null) {
            MDC.put((String)this.traceIdKey, (String)span.getSpanContext().getTraceId());
            MDC.put((String)this.spanIdKey, (String)span.getSpanContext().getSpanId());
        }
    }

    private void onScopeClosed(EventPublishingContextWrapper.ScopeClosedEvent event) {
        log.trace("Got scope closed event [{}]", (Object)event);
        MDC.remove((String)this.traceIdKey);
        MDC.remove((String)this.spanIdKey);
    }

    @Override
    public void onEvent(Object event) {
        if (event instanceof EventPublishingContextWrapper.ScopeAttachedEvent) {
            this.onScopeAttached((EventPublishingContextWrapper.ScopeAttachedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeClosedEvent) {
            this.onScopeClosed((EventPublishingContextWrapper.ScopeClosedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeRestoredEvent) {
            this.onScopeRestored((EventPublishingContextWrapper.ScopeRestoredEvent)event);
        }
    }
}

