/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.contextpropagation;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObservationAwareSpanThreadLocalAccessor
implements ThreadLocalAccessor<Span> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ObservationAwareSpanThreadLocalAccessor.class);
    final Map<Thread, SpanAction> spanActions = new ConcurrentHashMap<Thread, SpanAction>();
    public static final String KEY = "micrometer.tracing";
    private final Tracer tracer;
    private static final ObservationRegistry registry = ObservationRegistry.create();

    public ObservationAwareSpanThreadLocalAccessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object key() {
        return KEY;
    }

    public Span getValue() {
        Observation currentObservation = registry.getCurrentObservation();
        if (currentObservation != null) {
            TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)currentObservation.getContext().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
            Span currentSpan = this.tracer.currentSpan();
            if (currentSpan != null && !currentSpan.equals(tracingContext.getSpan())) {
                return currentSpan;
            }
            return null;
        }
        return this.tracer.currentSpan();
    }

    public void setValue(Span value) {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        Tracer.SpanInScope scope = this.tracer.withSpan(value);
        if (spanAction == null) {
            spanAction = new SpanAction(this.spanActions);
            this.spanActions.put(Thread.currentThread(), spanAction);
        }
        spanAction.setScope(scope);
    }

    public void setValue() {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        if (spanAction == null) {
            return;
        }
        Tracer.SpanInScope scope = this.tracer.withSpan(null);
        spanAction.setScope(scope);
    }

    public void restore(Span previousValue) {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        if (spanAction == null) {
            return;
        }
        spanAction.close();
        Span currentSpan = this.tracer.currentSpan();
        if (!previousValue.equals(currentSpan)) {
            String msg = "After closing the scope, current span <" + currentSpan + "> is not the same as the one to which you want to revert <" + previousValue + ">. Most likely you've opened a scope and forgotten to close it";
            log.warn(msg);
            assert (false) : msg;
        }
    }

    public void restore() {
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        if (spanAction != null) {
            spanAction.close();
        }
    }

    static class SpanAction
    implements Closeable {
        final SpanAction previous;
        final Map<Thread, SpanAction> todo;
        Closeable scope;

        SpanAction(Map<Thread, SpanAction> spanActions) {
            this.previous = spanActions.get(Thread.currentThread());
            this.todo = spanActions;
        }

        void setScope(Closeable scope) {
            this.scope = scope;
        }

        @Override
        public void close() {
            if (this.scope != null) {
                try {
                    this.scope.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.previous != null) {
                this.todo.put(Thread.currentThread(), this.previous);
            } else {
                this.todo.remove(Thread.currentThread());
            }
        }
    }
}

