/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.google.cloud.tools.jib.api.Credential;
import io.micronaut.build.AbstractDockerMojo;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.RegistryAuthLocator;

@Mojo(name="docker-push")
public class DockerPushMojo
extends AbstractDockerMojo {
    @Inject
    public DockerPushMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        block17: {
            String packaging = this.mavenProject.getPackaging();
            if ("docker".equals(packaging) || "docker-native".equals(packaging)) {
                Optional<String> toImage = this.jibConfigurationService.getToImage();
                if (toImage.isPresent()) {
                    this.getLog().info((CharSequence)("Pushing image: " + toImage.get()));
                    try (PushImageCmd pushImageCmd = this.dockerService.pushImageCmd(toImage.get());){
                        AuthConfig defaultAuthConfig = new AuthConfig();
                        if (this.jibConfigurationService.getCredentials().isPresent()) {
                            Credential credential = this.jibConfigurationService.getCredentials().get();
                            defaultAuthConfig.withUsername(credential.getUsername()).withPassword(credential.getPassword());
                        }
                        RegistryAuthLocator registryAuthLocator = RegistryAuthLocator.instance();
                        DockerImageName dockerImageName = DockerImageName.parse((String)toImage.get());
                        AuthConfig authConfig = registryAuthLocator.lookupAuthConfig(dockerImageName, defaultAuthConfig);
                        pushImageCmd.withAuthConfig(authConfig).start().awaitCompletion();
                        break block17;
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                }
                throw new MojoFailureException("The plugin com.google.cloud.tools:jib-maven-plugin is misconfigured. Missing <to> tag");
            }
            throw new MojoFailureException("The <packaging> must be set to either [docker] or [docker-native]");
        }
    }
}

