/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl;

import io.mockk.InternalPlatformDsl;
import io.mockk.MockKException;
import io.mockk.StackElement;
import io.mockk.core.ValueClassSupport;
import io.mockk.impl.JvmMultiNotifier;
import io.mockk.impl.MultiNotifier;
import io.mockk.impl.Ref;
import io.mockk.impl.WeakRef;
import io.mockk.impl.platform.CommonIdentityHashMapOf;
import io.mockk.impl.platform.CommonRef;
import io.mockk.impl.platform.JvmWeakConcurrentMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004J%\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\u00012\u0006\u0010\n\u001a\u0002H\t2\u0006\u0010\u000b\u001a\u0002H\t\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001J\u001e\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0011\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0006\u0010\u0018\u001a\u00020\u0015J\u0014\u0010\u0019\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J,\u0010\u001b\u001a\u0002H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u0001J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0001J-\u0010(\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000f\u001a\u00020\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H\t0\u0004H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\b\u0012\u0004\u0012\u0002H\t0,\"\u0004\b\u0000\u0010\tJ\u001e\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0011\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u0013J\u0006\u0010.\u001a\u00020/J\u001e\u00100\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0011\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u0013J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0001JC\u00104\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u0013*\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u00112\u0006\u00105\u001a\u0002H\u00122\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u001307\u00a2\u0006\u0002\u00108\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00069"}, d2={"Lio/mockk/impl/InternalPlatform;", "", "()V", "captureStackTrace", "Lkotlin/Function0;", "", "Lio/mockk/StackElement;", "copyFields", "", "T", "to", "from", "(Ljava/lang/Object;Ljava/lang/Object;)V", "hkd", "", "obj", "identityMap", "", "K", "V", "isPassedByValue", "", "cls", "Lkotlin/reflect/KClass;", "isRunningAndroidInstrumentationTest", "isValueClass", "clazz", "loadPlugin", "className", "msg", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "multiNotifier", "Lio/mockk/impl/MultiNotifier;", "packRef", "arg", "prettifyRecordingException", "", "ex", "ref", "Lio/mockk/impl/Ref;", "synchronized", "block", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "synchronizedMutableList", "", "synchronizedMutableMap", "time", "", "weakMap", "weakRef", "Lio/mockk/impl/WeakRef;", "value", "customComputeIfAbsent", "key", "valueFunc", "Lkotlin/Function1;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "mockk"})
public final class InternalPlatform {
    @NotNull
    public static final InternalPlatform INSTANCE = new InternalPlatform();

    private InternalPlatform() {
    }

    public final long time() {
        return System.nanoTime();
    }

    @NotNull
    public final Ref ref(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return new CommonRef(obj);
    }

    @NotNull
    public final String hkd(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = Integer.toHexString(InternalPlatformDsl.INSTANCE.identityHashCode(obj));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(InternalPlat\u2026sl.identityHashCode(obj))");
        return string;
    }

    public final boolean isPassedByValue(@NotNull KClass<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        KClass<?> kClass = cls;
        return Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.class)) ? true : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.class)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class)))))))));
    }

    public final <K, V> V customComputeIfAbsent(@NotNull Map<K, V> $this$customComputeIfAbsent, K key, @NotNull Function1<? super K, ? extends V> valueFunc) {
        Object object;
        Intrinsics.checkNotNullParameter($this$customComputeIfAbsent, (String)"<this>");
        Intrinsics.checkNotNullParameter(valueFunc, (String)"valueFunc");
        V value = $this$customComputeIfAbsent.get(key);
        if (value == null) {
            Object newValue = valueFunc.invoke(key);
            $this$customComputeIfAbsent.put(key, newValue);
            object = newValue;
        } else {
            object = value;
        }
        return object;
    }

    @NotNull
    public final <K, V> Map<K, V> weakMap() {
        return new JvmWeakConcurrentMap();
    }

    @NotNull
    public final <K, V> Map<K, V> identityMap() {
        return new CommonIdentityHashMapOf();
    }

    @NotNull
    public final <T> List<T> synchronizedMutableList() {
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf<T>())");
        return list;
    }

    @NotNull
    public final <K, V> Map<K, V> synchronizedMutableMap() {
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(hashMapOf())");
        return map;
    }

    private final boolean isValueClass(KClass<?> clazz) {
        boolean bl;
        try {
            bl = clazz.isValue();
        }
        catch (UnsupportedOperationException _) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final Object packRef(@Nullable Object arg) {
        return arg == null ? null : (this.isValueClass(Reflection.getOrCreateKotlinClass(arg.getClass())) ? this.packRef(ValueClassSupport.INSTANCE.getBoxedValue(arg)) : (this.isPassedByValue(ValueClassSupport.INSTANCE.getBoxedClass(Reflection.getOrCreateKotlinClass(arg.getClass()))) ? ValueClassSupport.INSTANCE.getBoxedValue(arg) : this.ref(arg)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Throwable prettifyRecordingException(@NotNull Throwable ex) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (ex instanceof ClassCastException) {
            throwable = (Throwable)new MockKException(ex.getMessage() == null ? "Class cast exception happened.\nWARN: 'message' property in ClassCastException provided by JVM is null, auto-hinting is not possible. \nThis is most probably happening due to Java optimization enabled. \nYou can use `hint` before call or use -XX:-OmitStackTraceInFastThrow to disable this optimization behaviour and make auto-hinting work. \nFor example in gradle use: \n\ntest {\n   jvmArgs '-XX:-OmitStackTraceInFastThrow'\n}" : "Class cast exception happened.\nProbably type information was erased.\nIn this case use `hint` before call to specify exact return type of a method.\n", ex);
            return throwable;
        }
        if (ex instanceof NoClassDefFoundError) {
            String string = ex.getMessage();
            if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"kotlinx/coroutines/", (boolean)false, (int)2, null) : false) {
                throwable = (Throwable)new MockKException("Add coroutines support artifact 'org.jetbrains.kotlinx:kotlinx-coroutines-core' to your project ", ex);
                return throwable;
            }
        }
        throwable = ex;
        return throwable;
    }

    public final <T> void copyFields(@NotNull T to, @NotNull T from) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        InternalPlatform.copyFields$copy(to, from, from.getClass());
    }

    @NotNull
    public final Function0<List<StackElement>> captureStackTrace() {
        Exception ex = new Exception("Stack trace");
        return (Function0)new Function0<List<? extends StackElement>>(ex){
            final /* synthetic */ Exception $ex;
            {
                this.$ex = $ex;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<StackElement> invoke() {
                void $this$mapTo$iv$iv;
                StackTraceElement[] stack;
                StackTraceElement[] stackTraceElementArray = this.$ex.getStackTrace();
                if (stackTraceElementArray == null) {
                    stackTraceElementArray = new StackTraceElement[]{};
                }
                StackTraceElement[] $this$map$iv = stack = stackTraceElementArray;
                boolean $i$f$map = false;
                StackTraceElement[] stackTraceElementArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    String string2;
                    String string3;
                    void it;
                    String string4;
                    void item$iv$iv;
                    void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string5 = string4 = it.getClassName();
                    if (string5 == null) {
                        string3 = "-";
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.className ?: \"-\"");
                        string3 = string4;
                    }
                    String string6 = string4 = it.getFileName();
                    if (string6 == null) {
                        string2 = "-";
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it.fileName ?: \"-\"");
                        string2 = string4;
                    }
                    String string7 = string4 = it.getMethodName();
                    if (string7 == null) {
                        string = "-";
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it.methodName ?: \"-\"");
                        string = string4;
                    }
                    collection.add(new StackElement(string3, string2, string, it.getLineNumber(), it.isNativeMethod()));
                }
                return (List)destination$iv$iv;
            }
        };
    }

    @NotNull
    public final WeakRef weakRef(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        WeakReference<Object> weakRef2 = new WeakReference<Object>(value);
        return new WeakRef(weakRef2){
            final /* synthetic */ WeakReference<Object> $weakRef;
            {
                this.$weakRef = $weakRef;
            }

            public Object getValue() {
                return this.$weakRef.get();
            }
        };
    }

    @NotNull
    public final MultiNotifier multiNotifier() {
        return new JvmMultiNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T synchronized(@NotNull Object obj, @NotNull Function0<? extends T> block2) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$synchronized = false;
        Object object = obj;
        synchronized (object) {
            Object object2;
            try {
                object2 = block2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object2;
        }
    }

    public final /* synthetic */ <T> T loadPlugin(String className, String msg) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        boolean $i$f$loadPlugin = false;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(Object.class), Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new MockKException("Failed to load plugin. " + className + ' ' + msg, (Throwable)ex);
        }
        return (T)object;
    }

    public static /* synthetic */ Object loadPlugin$default(InternalPlatform $this, String className, String msg, int n, Object object) {
        if ((n & 2) != 0) {
            msg = "";
        }
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        boolean $i$f$loadPlugin = false;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(Object.class), Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new MockKException("Failed to load plugin. " + className + ' ' + msg, (Throwable)ex);
        }
        return object;
    }

    public final boolean isRunningAndroidInstrumentationTest() {
        String string = System.getProperty("java.vendor", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.vendor\", \"\")");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string3, (CharSequence)"android", (boolean)false, (int)2, null);
    }

    private static final void copyFields$copy(Object to, Object from, Class<?> cls) {
        Field[] fieldArray = cls.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"cls.declaredFields");
        for (Field field : fieldArray) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (INSTANCE.isRunningAndroidInstrumentationTest()) {
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                if (StringsKt.startsWith$default((String)string, (String)"shadow$", (boolean)false, (int)2, null)) continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            InternalPlatformDsl.INSTANCE.makeAccessible((AccessibleObject)field);
            Object value = field.get(from);
            field.set(to, value);
        }
        if (cls.getSuperclass() != null) {
            Class<?> clazz = cls.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"cls.superclass");
            InternalPlatform.copyFields$copy(to, from, clazz);
        }
    }
}

