/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Options;
import io.nats.client.support.Validator;
import java.time.Duration;

public class JetStreamOptions {
    public static final Duration DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT;
    public static final JetStreamOptions DEFAULT_JS_OPTIONS = new Builder().build();
    private final String jsPrefix;
    private final Duration requestTimeout;
    private final boolean publishNoAck;
    private final boolean defaultPrefix;

    private JetStreamOptions(String inJsPrefix, Duration requestTimeout, boolean publishNoAck) {
        if (inJsPrefix == null) {
            this.defaultPrefix = true;
            this.jsPrefix = "$JS.API.";
        } else {
            this.defaultPrefix = false;
            this.jsPrefix = inJsPrefix;
        }
        this.requestTimeout = requestTimeout;
        this.publishNoAck = publishNoAck;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getPrefix() {
        return this.jsPrefix;
    }

    public boolean isDefaultPrefix() {
        return this.defaultPrefix;
    }

    public boolean isPublishNoAck() {
        return this.publishNoAck;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JetStreamOptions jso) {
        return new Builder(jso);
    }

    public static JetStreamOptions defaultOptions() {
        return DEFAULT_JS_OPTIONS;
    }

    public static class Builder {
        private String jsPrefix;
        private String featurePrefix;
        private Duration requestTimeout;
        private boolean publishNoAck;

        public Builder() {
        }

        public Builder(JetStreamOptions jso) {
            if (jso != null) {
                this.jsPrefix = jso.isDefaultPrefix() ? null : jso.jsPrefix;
                this.requestTimeout = jso.requestTimeout;
                this.publishNoAck = jso.publishNoAck;
            }
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder prefix(String prefix) {
            this.jsPrefix = Validator.ensureEndsWithDot(Validator.validatePrefixOrDomain(prefix, "Prefix", false));
            return this;
        }

        public Builder domain(String domain) {
            String valid = Validator.validatePrefixOrDomain(domain, "Prefix", false);
            this.jsPrefix = valid == null ? null : "$JS." + Validator.ensureEndsWithDot(valid) + "API.";
            return this;
        }

        public Builder publishNoAck(boolean publishNoAck) {
            this.publishNoAck = publishNoAck;
            return this;
        }

        public JetStreamOptions build() {
            this.requestTimeout = this.requestTimeout == null ? DEFAULT_TIMEOUT : this.requestTimeout;
            return new JetStreamOptions(this.jsPrefix, this.requestTimeout, this.publishNoAck);
        }
    }
}

