/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.JetStreamOptions;
import io.nats.client.Options;
import io.nats.client.support.Validator;
import java.time.Duration;

public class KeyValueOptions {
    public static final Duration DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT;
    public static final KeyValueOptions DEFAULT_JS_OPTIONS = new Builder().build();
    private final String featurePrefix;
    private final JetStreamOptions jso;

    private KeyValueOptions(String featurePrefix, JetStreamOptions jso) {
        this.featurePrefix = featurePrefix;
        this.jso = jso;
    }

    public String getFeaturePrefix() {
        return this.featurePrefix;
    }

    public JetStreamOptions getJetStreamOptions() {
        return this.jso;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KeyValueOptions jso) {
        return new Builder(jso);
    }

    public static class Builder {
        private String featurePrefix;
        private JetStreamOptions jso;

        public Builder() {
        }

        public Builder(KeyValueOptions kvo) {
            if (kvo != null) {
                this.featurePrefix = kvo.featurePrefix;
                this.jso = kvo.jso;
            }
        }

        public Builder featurePrefix(String featurePrefix) {
            this.featurePrefix = Validator.ensureEndsWithDot(Validator.validatePrefixOrDomain(featurePrefix, "Feature Prefix", false));
            return this;
        }

        public Builder jetStreamOptions(JetStreamOptions jso) {
            this.jso = jso;
            return this;
        }

        public KeyValueOptions build() {
            return new KeyValueOptions(this.featurePrefix, this.jso);
        }
    }
}

