/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;

public class Error {
    public static final int NOT_SET = -1;
    private final String json;
    private final int code;
    private final int apiErrorCode;
    private final String desc;

    static Error optionalInstance(String json) {
        String errorJson = JsonUtils.getJsonObject("error", json, null);
        return errorJson == null ? null : new Error(errorJson);
    }

    Error(String json) {
        this.json = json;
        this.code = JsonUtils.readInt(json, ApiConstants.CODE_RE, -1);
        this.apiErrorCode = JsonUtils.readInt(json, ApiConstants.ERR_CODE_RE, -1);
        this.desc = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE, "Unknown JetStream Error");
    }

    public int getCode() {
        return this.code;
    }

    public int getApiErrorCode() {
        return this.apiErrorCode;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        if (this.apiErrorCode == -1) {
            if (this.code == -1) {
                return this.desc;
            }
            return this.desc + " (" + this.code + ")";
        }
        if (this.code == -1) {
            return this.desc;
        }
        return this.desc + " [" + this.apiErrorCode + "]";
    }
}

