/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import java.util.List;

public class Placement
implements JsonSerializable {
    private final String cluster;
    private final List<String> tags;

    static Placement optionalInstance(String fullJson) {
        String objJson = JsonUtils.getJsonObject("placement", fullJson, null);
        return objJson == null ? null : new Placement(objJson);
    }

    Placement(String json) {
        this.cluster = JsonUtils.readString(json, ApiConstants.CLUSTER_RE);
        this.tags = JsonUtils.getStringList("tags", json);
    }

    public String getCluster() {
        return this.cluster;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Placement{cluster='" + this.cluster + '\'' + ", tags=" + this.tags + '}';
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "cluster", this.cluster);
        JsonUtils.addStrings(sb, "tags", this.tags);
        return JsonUtils.endJson(sb).toString();
    }
}

