/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;

public class PurgeResponse
extends ApiResponse<PurgeResponse> {
    private final boolean success;
    private final long purged;

    public PurgeResponse(Message msg) {
        super(msg);
        this.success = JsonUtils.readBoolean(this.json, ApiConstants.SUCCESS_RE);
        this.purged = JsonUtils.readLong(this.json, ApiConstants.PURGED_RE, 0L);
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Deprecated
    public int getPurgedCount() {
        return new Long(this.purged).intValue();
    }

    public long getPurged() {
        return this.purged;
    }

    public String toString() {
        return "PurgeResponse{success=" + this.success + ", purged=" + this.purged + '}';
    }
}

