/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.impl.ListRequestEngine;
import java.util.List;

abstract class AbstractListReader {
    private final String objectName;
    private final ListType listType;
    private final String filterFieldName;
    protected ListRequestEngine engine;

    void process(Message msg) throws JetStreamApiException {
        this.engine = new ListRequestEngine(msg);
        List<String> list = this.listType == ListType.OBJECTS ? this.engine.getObjectList(this.objectName) : this.engine.getStringList(this.objectName);
        this.processItems(list);
    }

    abstract void processItems(List<String> var1);

    AbstractListReader(String objectName, ListType listType) {
        this(objectName, listType, null);
    }

    AbstractListReader(String objectName, ListType listType, String filterFieldName) {
        this.objectName = objectName;
        this.listType = listType;
        this.filterFieldName = filterFieldName;
        this.engine = new ListRequestEngine();
    }

    byte[] nextJson() {
        return this.engine.internalNextJson();
    }

    byte[] nextJson(String filter) {
        if (this.filterFieldName == null) {
            throw new IllegalArgumentException("Filter not supported.");
        }
        return this.engine.internalNextJson(this.filterFieldName, filter);
    }

    boolean hasMore() {
        return this.engine.hasMore();
    }

    static enum ListType {
        OBJECTS,
        STRINGS;

    }
}

