/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.NatsJetStreamConstants;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamSubscription
extends NatsSubscription
implements JetStreamSubscription,
NatsJetStreamConstants {
    public static final String SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL = "Subscription type does not support pull.";
    protected final NatsJetStream js;
    protected String stream;
    protected String consumerName;
    protected List<MessageManager> managers;

    NatsJetStreamSubscription(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher, NatsJetStream js, String stream, String consumer, MessageManager ... managers) {
        super(sid, subject, queueName, connection, dispatcher);
        this.js = js;
        this.stream = stream;
        this.consumerName = consumer;
        this.managers = new ArrayList<MessageManager>();
        for (MessageManager mm : managers) {
            if (mm == null) continue;
            this.managers.add(mm);
            mm.setSub(this);
        }
    }

    String getConsumerName() {
        return this.consumerName;
    }

    String getStream() {
        return this.stream;
    }

    boolean isPullMode() {
        return false;
    }

    List<MessageManager> getManagers() {
        return this.managers;
    }

    @Override
    void invalidate() {
        for (MessageManager mm : this.managers) {
            mm.shutdown();
        }
        super.invalidate();
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, IllegalStateException {
        if (timeout == null || timeout.toMillis() <= 0L) {
            return this.nextMsgNullOrLteZero(timeout);
        }
        return this.nextMessageWithEndTime(System.currentTimeMillis() + timeout.toMillis());
    }

    @Override
    public Message nextMessage(long timeoutMillis) throws InterruptedException, IllegalStateException {
        if (timeoutMillis <= 0L) {
            return this.nextMsgNullOrLteZero(Duration.ZERO);
        }
        return this.nextMessageWithEndTime(System.currentTimeMillis() + timeoutMillis);
    }

    protected Message nextMsgNullOrLteZero(Duration timeout) throws InterruptedException {
        NatsMessage msg = this.nextMessageInternal(timeout);
        while (msg != null && this.anyManaged(msg)) {
            msg = this.nextMessageInternal(timeout);
        }
        return msg;
    }

    protected Message nextMessageWithEndTime(long endTime) throws InterruptedException {
        long millis = endTime - System.currentTimeMillis();
        while (millis > 0L) {
            NatsMessage msg = this.nextMessageInternal(Duration.ofMillis(millis));
            if (msg != null && !this.anyManaged(msg)) {
                return msg;
            }
            millis = endTime - System.currentTimeMillis();
        }
        return null;
    }

    boolean anyManaged(Message msg) {
        for (MessageManager mm : this.managers) {
            if (!mm.manage(msg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pull(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        return this.js.lookupConsumerInfo(this.stream, this.consumerName);
    }

    public String toString() {
        return "NatsJetStreamSubscription{consumer='" + this.consumerName + '\'' + ", stream='" + this.stream + '\'' + ", deliver='" + this.getSubject() + '\'' + ", isPullMode=" + this.isPullMode() + '}';
    }
}

