/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.MetadataDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MetadataEntriesDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class MetadataRoutesApi {
    private ApiClient localVarApiClient;

    public MetadataRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetadataRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAccountMetadataCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/account/{accountId}".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountMetadataValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMetadata(Async)");
        }
        Call localVarCall = this.getAccountMetadataCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public MetadataEntriesDTO getAccountMetadata(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = this.getAccountMetadataWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataEntriesDTO> getAccountMetadataWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.getAccountMetadataValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountMetadataAsync(String accountId, Integer pageSize, String id, String ordering, ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountMetadataValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountMetadataByKeyCall(String accountId, String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/account/{accountId}/key/{key}".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountMetadataByKeyValidateBeforeCall(String accountId, String key, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMetadataByKey(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getAccountMetadataByKey(Async)");
        }
        Call localVarCall = this.getAccountMetadataByKeyCall(accountId, key, _callback);
        return localVarCall;
    }

    public MetadataEntriesDTO getAccountMetadataByKey(String accountId, String key) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = this.getAccountMetadataByKeyWithHttpInfo(accountId, key);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataEntriesDTO> getAccountMetadataByKeyWithHttpInfo(String accountId, String key) throws ApiException {
        Call localVarCall = this.getAccountMetadataByKeyValidateBeforeCall(accountId, key, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountMetadataByKeyAsync(String accountId, String key, ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountMetadataByKeyValidateBeforeCall(accountId, key, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountMetadataByKeyAndSenderCall(String accountId, String key, String publicKey, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/account/{accountId}/key/{key}/sender/{publicKey}".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{publicKey\\}", this.localVarApiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountMetadataByKeyAndSenderValidateBeforeCall(String accountId, String key, String publicKey, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMetadataByKeyAndSender(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender(Async)");
        }
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAccountMetadataByKeyAndSender(Async)");
        }
        Call localVarCall = this.getAccountMetadataByKeyAndSenderCall(accountId, key, publicKey, _callback);
        return localVarCall;
    }

    public MetadataDTO getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey) throws ApiException {
        ApiResponse<MetadataDTO> localVarResp = this.getAccountMetadataByKeyAndSenderWithHttpInfo(accountId, key, publicKey);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataDTO> getAccountMetadataByKeyAndSenderWithHttpInfo(String accountId, String key, String publicKey) throws ApiException {
        Call localVarCall = this.getAccountMetadataByKeyAndSenderValidateBeforeCall(accountId, key, publicKey, null);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountMetadataByKeyAndSenderAsync(String accountId, String key, String publicKey, ApiCallback<MetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountMetadataByKeyAndSenderValidateBeforeCall(accountId, key, publicKey, _callback);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMosaicMetadataCall(String mosaicId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", this.localVarApiClient.escapeString(mosaicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMosaicMetadataValidateBeforeCall(String mosaicId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicMetadata(Async)");
        }
        Call localVarCall = this.getMosaicMetadataCall(mosaicId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public MetadataEntriesDTO getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = this.getMosaicMetadataWithHttpInfo(mosaicId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataEntriesDTO> getMosaicMetadataWithHttpInfo(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.getMosaicMetadataValidateBeforeCall(mosaicId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMosaicMetadataAsync(String mosaicId, Integer pageSize, String id, String ordering, ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {
        Call localVarCall = this.getMosaicMetadataValidateBeforeCall(mosaicId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMosaicMetadataByKeyCall(String mosaicId, String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}".replaceAll("\\{mosaicId\\}", this.localVarApiClient.escapeString(mosaicId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMosaicMetadataByKeyValidateBeforeCall(String mosaicId, String key, ApiCallback _callback) throws ApiException {
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getMosaicMetadataByKey(Async)");
        }
        Call localVarCall = this.getMosaicMetadataByKeyCall(mosaicId, key, _callback);
        return localVarCall;
    }

    public MetadataEntriesDTO getMosaicMetadataByKey(String mosaicId, String key) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = this.getMosaicMetadataByKeyWithHttpInfo(mosaicId, key);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataEntriesDTO> getMosaicMetadataByKeyWithHttpInfo(String mosaicId, String key) throws ApiException {
        Call localVarCall = this.getMosaicMetadataByKeyValidateBeforeCall(mosaicId, key, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMosaicMetadataByKeyAsync(String mosaicId, String key, ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {
        Call localVarCall = this.getMosaicMetadataByKeyValidateBeforeCall(mosaicId, key, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMosaicMetadataByKeyAndSenderCall(String mosaicId, String key, String publicKey, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{publicKey}".replaceAll("\\{mosaicId\\}", this.localVarApiClient.escapeString(mosaicId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{publicKey\\}", this.localVarApiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMosaicMetadataByKeyAndSenderValidateBeforeCall(String mosaicId, String key, String publicKey, ApiCallback _callback) throws ApiException {
        if (mosaicId == null) {
            throw new ApiException("Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender(Async)");
        }
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getMosaicMetadataByKeyAndSender(Async)");
        }
        Call localVarCall = this.getMosaicMetadataByKeyAndSenderCall(mosaicId, key, publicKey, _callback);
        return localVarCall;
    }

    public MetadataDTO getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey) throws ApiException {
        ApiResponse<MetadataDTO> localVarResp = this.getMosaicMetadataByKeyAndSenderWithHttpInfo(mosaicId, key, publicKey);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataDTO> getMosaicMetadataByKeyAndSenderWithHttpInfo(String mosaicId, String key, String publicKey) throws ApiException {
        Call localVarCall = this.getMosaicMetadataByKeyAndSenderValidateBeforeCall(mosaicId, key, publicKey, null);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMosaicMetadataByKeyAndSenderAsync(String mosaicId, String key, String publicKey, ApiCallback<MetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.getMosaicMetadataByKeyAndSenderValidateBeforeCall(mosaicId, key, publicKey, _callback);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespaceMetadataCall(String namespaceId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/namespace/{namespaceId}".replaceAll("\\{namespaceId\\}", this.localVarApiClient.escapeString(namespaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespaceMetadataValidateBeforeCall(String namespaceId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespaceMetadata(Async)");
        }
        Call localVarCall = this.getNamespaceMetadataCall(namespaceId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public MetadataEntriesDTO getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = this.getNamespaceMetadataWithHttpInfo(namespaceId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataWithHttpInfo(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.getNamespaceMetadataValidateBeforeCall(namespaceId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespaceMetadataAsync(String namespaceId, Integer pageSize, String id, String ordering, ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {
        Call localVarCall = this.getNamespaceMetadataValidateBeforeCall(namespaceId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespaceMetadataByKeyCall(String namespaceId, String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}".replaceAll("\\{namespaceId\\}", this.localVarApiClient.escapeString(namespaceId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespaceMetadataByKeyValidateBeforeCall(String namespaceId, String key, ApiCallback _callback) throws ApiException {
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getNamespaceMetadataByKey(Async)");
        }
        Call localVarCall = this.getNamespaceMetadataByKeyCall(namespaceId, key, _callback);
        return localVarCall;
    }

    public MetadataEntriesDTO getNamespaceMetadataByKey(String namespaceId, String key) throws ApiException {
        ApiResponse<MetadataEntriesDTO> localVarResp = this.getNamespaceMetadataByKeyWithHttpInfo(namespaceId, key);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataByKeyWithHttpInfo(String namespaceId, String key) throws ApiException {
        Call localVarCall = this.getNamespaceMetadataByKeyValidateBeforeCall(namespaceId, key, null);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespaceMetadataByKeyAsync(String namespaceId, String key, ApiCallback<MetadataEntriesDTO> _callback) throws ApiException {
        Call localVarCall = this.getNamespaceMetadataByKeyValidateBeforeCall(namespaceId, key, _callback);
        Type localVarReturnType = new TypeToken<MetadataEntriesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getNamespaceMetadataByKeyAndSenderCall(String namespaceId, String key, String publicKey, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{publicKey}".replaceAll("\\{namespaceId\\}", this.localVarApiClient.escapeString(namespaceId.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{publicKey\\}", this.localVarApiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getNamespaceMetadataByKeyAndSenderValidateBeforeCall(String namespaceId, String key, String publicKey, ApiCallback _callback) throws ApiException {
        if (namespaceId == null) {
            throw new ApiException("Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender(Async)");
        }
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getNamespaceMetadataByKeyAndSender(Async)");
        }
        Call localVarCall = this.getNamespaceMetadataByKeyAndSenderCall(namespaceId, key, publicKey, _callback);
        return localVarCall;
    }

    public MetadataDTO getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey) throws ApiException {
        ApiResponse<MetadataDTO> localVarResp = this.getNamespaceMetadataByKeyAndSenderWithHttpInfo(namespaceId, key, publicKey);
        return localVarResp.getData();
    }

    public ApiResponse<MetadataDTO> getNamespaceMetadataByKeyAndSenderWithHttpInfo(String namespaceId, String key, String publicKey) throws ApiException {
        Call localVarCall = this.getNamespaceMetadataByKeyAndSenderValidateBeforeCall(namespaceId, key, publicKey, null);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getNamespaceMetadataByKeyAndSenderAsync(String namespaceId, String key, String publicKey, ApiCallback<MetadataDTO> _callback) throws ApiException {
        Call localVarCall = this.getNamespaceMetadataByKeyAndSenderValidateBeforeCall(namespaceId, key, publicKey, _callback);
        Type localVarReturnType = new TypeToken<MetadataDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

