/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher.utils;

import io.nessus.utils.AssertState;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeterministicRandom
extends SecureRandom {
    final byte[] bytes;
    final AtomicBoolean used = new AtomicBoolean();

    public DeterministicRandom(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public void nextBytes(byte[] buffer) {
        AssertState.assertFalse((Boolean)this.used.getAndSet(true), (String)"Generator can only be used once");
        AssertState.assertTrue((Boolean)(buffer.length <= this.bytes.length ? 1 : 0), (String)"Insufficient number of bytes");
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.bytes[i];
        }
    }
}

