/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.marshalling.ChannelBufferByteInput;
import io.netty.handler.codec.marshalling.LimitingByteInput;
import io.netty.handler.codec.marshalling.UnmarshallerProvider;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

public class CompatibleMarshallingDecoder
extends ReplayingDecoder<Object, Void> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;

    public CompatibleMarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        this.provider = provider;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    public Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        Object input = new ChannelBufferByteInput(buffer);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            input = new LimitingByteInput((ByteInput)input, this.maxObjectSize);
        }
        try {
            unmarshaller.start((ByteInput)input);
            Object obj = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = obj;
            return object;
        }
        catch (LimitingByteInput.TooBigObjectException e) {
            throw new TooLongFrameException("Object to big to unmarshal");
        }
        finally {
            unmarshaller.close();
        }
    }

    @Override
    public Object decodeLast(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        switch (buffer.readableBytes()) {
            case 0: {
                return null;
            }
            case 1: {
                if (buffer.getByte(buffer.readerIndex()) != 121) break;
                buffer.skipBytes(1);
                return null;
            }
        }
        return this.decode(ctx, buffer);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof TooLongFrameException) {
            ctx.close();
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }
}

